/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile;

import androidx.annotation.NonNull;
import com.adobe.marketing.mobile.AdobeCallback;
import com.adobe.marketing.mobile.AdobeCallbackWithError;
import com.adobe.marketing.mobile.AdobeError;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.Extension;
import com.adobe.marketing.mobile.MobileCore;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.userprofile.UserProfileExtension;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.DataReaderException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserProfile {
    private static final String LOG_TAG = "UserProfile";
    private static final String EXTENSION_VERSION = "3.0.1";
    private static final String CLASS_NAME = "UserProfile";
    private static final String UPDATE_DATA_KEY = "userprofileupdatekey";
    private static final String GET_DATA_ATTRIBUTES = "userprofilegetattributes";
    private static final String REMOVE_DATA_KEYS = "userprofileremovekeys";
    private static final long API_TIMEOUT = 5000L;
    public static final Class<? extends Extension> EXTENSION = UserProfileExtension.class;

    private UserProfile() {
    }

    @NonNull
    public static String extensionVersion() {
        return EXTENSION_VERSION;
    }

    public static void updateUserAttributes(@NonNull Map<String, Object> attributeMap) {
        if (attributeMap == null || attributeMap.isEmpty()) {
            Log.debug((String)"UserProfile", (String)"UserProfile", (String)"updateUserAttributes - the given attribute map is null or empty, no event was dispatched", (Object[])new Object[0]);
            return;
        }
        HashMap<String, Map<String, Object>> eventDataMap = new HashMap<String, Map<String, Object>>();
        eventDataMap.put(UPDATE_DATA_KEY, attributeMap);
        Event event = new Event.Builder("UserProfileUpdate", "com.adobe.eventType.userProfile", "com.adobe.eventSource.requestProfile").setEventData(eventDataMap).build();
        MobileCore.dispatchEvent((Event)event);
    }

    public static void removeUserAttributes(@NonNull List<String> attributeNames) {
        if (attributeNames == null || attributeNames.isEmpty()) {
            Log.debug((String)"UserProfile", (String)"UserProfile", (String)"removeUserAttributes - the given attribute map is null or empty, no event was dispatched", (Object[])new Object[0]);
            return;
        }
        Log.trace((String)"UserProfile", (String)"UserProfile", (String)"Removing user attributes", (Object[])new Object[0]);
        HashMap<String, List<String>> eventDataMap = new HashMap<String, List<String>>();
        eventDataMap.put(REMOVE_DATA_KEYS, attributeNames);
        Event event = new Event.Builder("RemoveUserProfile", "com.adobe.eventType.userProfile", "com.adobe.eventSource.requestReset").setEventData(eventDataMap).build();
        MobileCore.dispatchEvent((Event)event);
    }

    public static void getUserAttributes(@NonNull List<String> keys, final @NonNull AdobeCallback<Map<String, Object>> callback) {
        if (callback == null) {
            Log.debug((String)"UserProfile", (String)"UserProfile", (String)"getUserAttributes - the given AdobeCallback is null, no event was dispatched", (Object[])new Object[0]);
            return;
        }
        if (keys == null || keys.size() == 0) {
            Log.debug((String)"UserProfile", (String)"UserProfile", (String)"getUserAttributes - the given key map is null or empty, no event was dispatched", (Object[])new Object[0]);
            callback.call(new HashMap());
            return;
        }
        Log.trace((String)"UserProfile", (String)"UserProfile", (String)"Getting user attributes", (Object[])new Object[0]);
        HashMap<String, List<String>> eventDataMap = new HashMap<String, List<String>>();
        eventDataMap.put(GET_DATA_ATTRIBUTES, keys);
        Event event = new Event.Builder("getUserAttributes", "com.adobe.eventType.userProfile", "com.adobe.eventSource.requestProfile").setEventData(eventDataMap).build();
        AdobeCallbackWithError<Map<String, Object>> adobeCallbackWithError = new AdobeCallbackWithError<Map<String, Object>>(){
            final AdobeCallbackWithError userCallbackWithError;
            {
                this.userCallbackWithError = callback instanceof AdobeCallbackWithError ? (AdobeCallbackWithError)callback : null;
            }

            public void fail(AdobeError adobeError) {
                if (this.userCallbackWithError != null) {
                    this.userCallbackWithError.fail(adobeError);
                }
            }

            public void call(Map<String, Object> profileMap) {
                callback.call(profileMap);
            }
        };
        MobileCore.dispatchEventWithResponseCallback((Event)event, (long)5000L, (AdobeCallbackWithError)new AdobeCallbackWithError<Event>(){
            final /* synthetic */ AdobeCallbackWithError val$adobeCallbackWithError;
            final /* synthetic */ AdobeCallback val$callback;
            {
                this.val$adobeCallbackWithError = adobeCallbackWithError;
                this.val$callback = adobeCallback;
            }

            public void fail(AdobeError adobeError) {
                this.val$adobeCallbackWithError.fail(adobeError);
            }

            public void call(Event event) {
                try {
                    Map profileMap = DataReader.getTypedMap(Object.class, (Map)event.getEventData(), (String)UserProfile.GET_DATA_ATTRIBUTES);
                    this.val$callback.call((Object)profileMap);
                }
                catch (DataReaderException e) {
                    Log.error((String)"UserProfile", (String)"UserProfile", (String)"Failed to retrieve user attributes from given user profile event.", (Object[])new Object[0]);
                    this.val$adobeCallbackWithError.fail(AdobeError.UNEXPECTED_ERROR);
                }
            }
        });
    }
}

