/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.target;

import com.adobe.marketing.mobile.AdobeCallback;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.target.AdobeTargetDetailedCallback;
import com.adobe.marketing.mobile.target.TargetParameters;
import com.adobe.marketing.mobile.target.TargetUtils;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.DataReaderException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TargetRequest {
    private static final String CLASS_NAME = "TargetProduct";
    private final String mboxName;
    private final TargetParameters targetParameters;
    private final String defaultContent;
    private String responsePairId;
    private AdobeCallback<String> contentCallback;
    private AdobeTargetDetailedCallback contentWithDataCallback;

    public TargetRequest(String mboxName, TargetParameters targetParameters, String defaultContent, AdobeCallback<String> contentCallback) {
        this.mboxName = mboxName;
        this.targetParameters = targetParameters;
        this.defaultContent = defaultContent;
        this.contentCallback = contentCallback;
    }

    public TargetRequest(String mboxName, TargetParameters targetParameters, String defaultContent, AdobeTargetDetailedCallback contentWithDataCallback) {
        this.mboxName = mboxName;
        this.targetParameters = targetParameters;
        this.defaultContent = defaultContent;
        this.contentWithDataCallback = contentWithDataCallback;
    }

    public String getMboxName() {
        return this.mboxName;
    }

    TargetParameters getTargetParameters() {
        return this.targetParameters;
    }

    public String getDefaultContent() {
        return this.defaultContent;
    }

    String getResponsePairId() {
        return this.responsePairId;
    }

    public AdobeCallback<String> getContentCallback() {
        return this.contentCallback;
    }

    public AdobeTargetDetailedCallback getContentWithDataCallback() {
        return this.contentWithDataCallback;
    }

    public void setResponsePairId(String pairId) {
        this.responsePairId = pairId;
    }

    public Map<String, Object> toEventData() {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("name", this.mboxName);
        requestMap.put("defaultContent", this.defaultContent);
        requestMap.put("responsePairId", this.responsePairId);
        if (this.targetParameters != null) {
            requestMap.put("targetparams", this.targetParameters.toEventData());
        }
        return requestMap;
    }

    static TargetRequest fromEventData(Map<String, Object> data) {
        if (TargetUtils.isNullOrEmpty(data)) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"Cannot create TargetRequest object, provided data Map is empty or null.", (Object[])new Object[0]);
            return null;
        }
        try {
            String mboxName = DataReader.getString(data, (String)"name");
            Map targetParameters = DataReader.getTypedMap(Object.class, data, (String)"targetparams");
            String defaultContent = DataReader.getString(data, (String)"defaultContent");
            String responsePairId = DataReader.getString(data, (String)"responsePairId");
            TargetRequest targetRequest = new TargetRequest(mboxName, TargetParameters.fromEventData(targetParameters), defaultContent, (AdobeCallback<String>)((AdobeCallback)null));
            targetRequest.setResponsePairId(responsePairId);
            return targetRequest;
        }
        catch (DataReaderException e) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"Cannot create TargetRequest object, provided data contains invalid fields.", (Object[])new Object[0]);
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetRequest that = (TargetRequest)o;
        if (this.mboxName != null ? !this.mboxName.equals(that.mboxName) : that.mboxName != null) {
            return false;
        }
        if (this.targetParameters != null ? !this.targetParameters.equals(that.targetParameters) : that.targetParameters != null) {
            return false;
        }
        if (this.defaultContent != null ? !this.defaultContent.equals(that.defaultContent) : that.defaultContent != null) {
            return false;
        }
        if (this.responsePairId != null ? !this.responsePairId.equals(that.responsePairId) : that.responsePairId != null) {
            return false;
        }
        if (this.contentCallback != null ? !this.contentCallback.equals(that.contentCallback) : that.contentCallback != null) {
            return false;
        }
        return this.contentWithDataCallback != null ? this.contentWithDataCallback.equals(that.contentWithDataCallback) : that.contentWithDataCallback == null;
    }

    public int hashCode() {
        return Objects.hash(this.mboxName, this.targetParameters, this.contentCallback, this.contentWithDataCallback, this.defaultContent, this.responsePairId);
    }
}

