/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.target;

import androidx.annotation.NonNull;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.ui.FloatingButton;
import com.adobe.marketing.mobile.services.ui.Presentable;
import com.adobe.marketing.mobile.services.ui.PresentationError;
import com.adobe.marketing.mobile.services.ui.floatingbutton.FloatingButtonEventListener;
import com.adobe.marketing.mobile.target.TargetPreviewManager;

class TargetPreviewButtonEventListener
implements FloatingButtonEventListener {
    private static final String CLASS_NAME = "TargetPreviewButtonEventListener";
    private final TargetPreviewManager previewManager;

    TargetPreviewButtonEventListener(TargetPreviewManager targetPreviewManager) {
        this.previewManager = targetPreviewManager;
    }

    public void onTapDetected(@NonNull Presentable<FloatingButton> presentable) {
        Log.debug((String)"Target", (String)CLASS_NAME, (String)"Target preview button was clicked", (Object[])new Object[0]);
        this.previewManager.fetchWebView();
    }

    public void onPanDetected(@NonNull Presentable<FloatingButton> presentable) {
    }

    public void onDismiss(@NonNull Presentable<FloatingButton> presentable) {
        Log.debug((String)"Target", (String)CLASS_NAME, (String)"Target preview button was dismissed", (Object[])new Object[0]);
    }

    public void onError(@NonNull Presentable<FloatingButton> presentable, @NonNull PresentationError presentationError) {
        Log.debug((String)"Target", (String)CLASS_NAME, (String)"onError - Failed to display Target preview button", (Object[])new Object[0]);
    }

    public void onHide(@NonNull Presentable<FloatingButton> presentable) {
    }

    public void onShow(@NonNull Presentable<FloatingButton> presentable) {
        Log.debug((String)"Target", (String)CLASS_NAME, (String)"Target preview button was shown", (Object[])new Object[0]);
    }
}

