/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.target;

import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.target.TargetParameters;
import com.adobe.marketing.mobile.target.TargetUtils;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.DataReaderException;
import java.util.HashMap;
import java.util.Map;

public class TargetPrefetch {
    private static final String CLASS_NAME = "TargetPrefetch";
    private final String mboxName;
    private final TargetParameters targetParameters;

    String getMboxName() {
        return this.mboxName;
    }

    TargetParameters getTargetParameters() {
        return this.targetParameters;
    }

    public TargetPrefetch(String mboxName, TargetParameters targetParameters) {
        this.mboxName = mboxName;
        this.targetParameters = targetParameters;
    }

    public Map<String, Object> toEventData() {
        HashMap<String, Object> prefetchMap = new HashMap<String, Object>();
        prefetchMap.put("name", this.mboxName);
        if (this.targetParameters != null) {
            prefetchMap.put("targetparams", this.targetParameters.toEventData());
        }
        return prefetchMap;
    }

    static TargetPrefetch fromEventData(Map<String, Object> data) {
        if (TargetUtils.isNullOrEmpty(data)) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"Cannot create TargetPrefetch object, provided data Map is empty or null.", (Object[])new Object[0]);
            return null;
        }
        try {
            String mboxName = DataReader.getString(data, (String)"name");
            Map targetParameters = DataReader.getTypedMap(Object.class, data, (String)"targetparams");
            return new TargetPrefetch(mboxName, TargetParameters.fromEventData(targetParameters));
        }
        catch (DataReaderException e) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"Cannot create TargetPrefetch object, provided data contains invalid fields.", (Object[])new Object[0]);
            return null;
        }
    }
}

