/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.target;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.Extension;
import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.MobilePrivacyStatus;
import com.adobe.marketing.mobile.SharedStateResolution;
import com.adobe.marketing.mobile.SharedStateResult;
import com.adobe.marketing.mobile.Target;
import com.adobe.marketing.mobile.services.DeviceInforming;
import com.adobe.marketing.mobile.services.HttpConnecting;
import com.adobe.marketing.mobile.services.HttpMethod;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NamedCollection;
import com.adobe.marketing.mobile.services.NetworkCallback;
import com.adobe.marketing.mobile.services.NetworkRequest;
import com.adobe.marketing.mobile.services.Networking;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.services.ui.UIService;
import com.adobe.marketing.mobile.services.uri.UriOpening;
import com.adobe.marketing.mobile.target.TargetConstants;
import com.adobe.marketing.mobile.target.TargetParameters;
import com.adobe.marketing.mobile.target.TargetPrefetch;
import com.adobe.marketing.mobile.target.TargetPreviewManager;
import com.adobe.marketing.mobile.target.TargetRequest;
import com.adobe.marketing.mobile.target.TargetRequestBuilder;
import com.adobe.marketing.mobile.target.TargetResponseParser;
import com.adobe.marketing.mobile.target.TargetState;
import com.adobe.marketing.mobile.target.TargetUtils;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.DataReaderException;
import com.adobe.marketing.mobile.util.JSONUtils;
import com.adobe.marketing.mobile.util.StringUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class TargetExtension
extends Extension {
    private static final String CLASS_NAME = "TargetExtension";
    private static final String TARGET_EVENT_DISPATCH_MESSAGE = "Dispatching - Target response content event";
    private final DeviceInforming deviceInfoService = ServiceProvider.getInstance().getDeviceInfoService();
    private final Networking networkService;
    private final UIService uiService;
    private final UriOpening uriService;
    private final Context context;
    private final TargetState targetState;
    private final TargetResponseParser targetResponseParser;
    private final TargetRequestBuilder targetRequestBuilder;
    private final TargetPreviewManager targetPreviewManager;

    protected TargetExtension(ExtensionApi extensionApi) {
        this(extensionApi, null, null, null, null);
    }

    @VisibleForTesting
    protected TargetExtension(ExtensionApi extensionApi, TargetState targetState, TargetPreviewManager targetPreviewManager, TargetRequestBuilder requestBuilder, TargetResponseParser responseParser) {
        super(extensionApi);
        NamedCollection dataStore = ServiceProvider.getInstance().getDataStoreService().getNamedCollection("ADOBEMOBILE_TARGET");
        this.networkService = ServiceProvider.getInstance().getNetworkService();
        this.uiService = ServiceProvider.getInstance().getUIService();
        this.uriService = ServiceProvider.getInstance().getUriService();
        this.context = ServiceProvider.getInstance().getAppContextService().getApplicationContext();
        this.targetState = targetState != null ? targetState : new TargetState(dataStore);
        this.targetPreviewManager = targetPreviewManager != null ? targetPreviewManager : new TargetPreviewManager(this.networkService, this.uiService, this.uriService, this.context);
        this.targetRequestBuilder = requestBuilder != null ? requestBuilder : this.getRequestBuilder();
        this.targetResponseParser = responseParser != null ? responseParser : new TargetResponseParser();
    }

    @NonNull
    protected String getName() {
        return "com.adobe.module.target";
    }

    protected String getFriendlyName() {
        return "Target";
    }

    protected String getVersion() {
        return Target.extensionVersion();
    }

    public boolean readyForEvent(@NonNull Event event) {
        this.targetState.updateConfigurationSharedState(this.retrieveConfigurationSharedState(event));
        return this.targetState.getStoredConfigurationSharedState() != null;
    }

    protected void onRegistered() {
        this.getApi().registerEventListener("com.adobe.eventType.target", "com.adobe.eventSource.requestContent", this::handleTargetRequestContentEvent);
        this.getApi().registerEventListener("com.adobe.eventType.target", "com.adobe.eventSource.requestReset", this::handleTargetRequestResetEvent);
        this.getApi().registerEventListener("com.adobe.eventType.target", "com.adobe.eventSource.requestIdentity", this::handleTargetRequestIdentityEvent);
        this.getApi().registerEventListener("com.adobe.eventType.generic.data", "com.adobe.eventSource.os", this::handleGenericDataOSEvent);
        this.getApi().registerEventListener("com.adobe.eventType.configuration", "com.adobe.eventSource.responseContent", this::handleConfigurationResponseContentEvent);
    }

    void handleTargetRequestContentEvent(@NonNull Event event) {
        if (TargetUtils.isNullOrEmpty(event.getEventData())) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"handleTargetRequestContentEvent - Failed to process Target request content event, event data is null/ empty.", (Object[])new Object[0]);
            return;
        }
        Map eventData = event.getEventData();
        if (DataReader.optBoolean((Map)eventData, (String)"israwevent", (boolean)false)) {
            this.handleRawRequest(event);
            return;
        }
        if (eventData.containsKey("prefetch")) {
            List flattenedPrefetchRequests;
            try {
                flattenedPrefetchRequests = (List)eventData.get("prefetch");
            }
            catch (ClassCastException e) {
                Log.warning((String)"Target", (String)CLASS_NAME, (String)"handleTargetRequestContentEvent -  Failed to get TargetExtension Prefetch list from event data, %s", (Object[])new Object[]{e});
                return;
            }
            if (TargetUtils.isNullOrEmpty(flattenedPrefetchRequests)) {
                Log.warning((String)"Target", (String)CLASS_NAME, (String)"handleTargetRequestContentEvent -Failed to retrieve Target Prefetch list (%s)", (Object[])new Object[]{"Empty or null prefetch requests list"});
                this.dispatchMboxPrefetchResult("Empty or null prefetch requests list", event);
                return;
            }
            ArrayList<TargetPrefetch> targetPrefetchRequests = new ArrayList<TargetPrefetch>();
            for (Map prefetch : flattenedPrefetchRequests) {
                TargetPrefetch targetPrefetch = TargetPrefetch.fromEventData(prefetch);
                if (targetPrefetch == null) continue;
                targetPrefetchRequests.add(targetPrefetch);
            }
            this.handleMboxPrefetch(targetPrefetchRequests, event);
            return;
        }
        if (eventData.containsKey("request")) {
            List flattenedLocationRequests;
            try {
                flattenedLocationRequests = (List)eventData.get("request");
            }
            catch (ClassCastException e) {
                Log.warning((String)"Target", (String)CLASS_NAME, (String)"handleTargetRequestContentEvent -  Failed to get Target Request list from event data, %s", (Object[])new Object[]{e});
                return;
            }
            if (TargetUtils.isNullOrEmpty(flattenedLocationRequests)) {
                Log.warning((String)"Target", (String)CLASS_NAME, (String)"handleTargetRequestContentEvent -Failed to retrieve Target location content (%s)", (Object[])new Object[]{"No valid Target Request found."});
                return;
            }
            ArrayList<TargetRequest> targetRequests = new ArrayList<TargetRequest>();
            for (Map request : flattenedLocationRequests) {
                TargetRequest targetRequest = TargetRequest.fromEventData(request);
                if (targetRequest == null) continue;
                targetRequests.add(targetRequest);
            }
            this.loadRequests(targetRequests, event);
            return;
        }
        if (DataReader.optBoolean((Map)eventData, (String)"islocationdisplayed", (boolean)false)) {
            this.handleLocationsDisplayed(event);
            return;
        }
        if (DataReader.optBoolean((Map)eventData, (String)"islocationclicked", (boolean)false)) {
            this.handleLocationClicked(event);
            return;
        }
        String restartDeeplink = DataReader.optString((Map)eventData, (String)"restartdeeplink", null);
        if (!StringUtils.isNullOrEmpty((String)restartDeeplink)) {
            this.setPreviewRestartDeepLink(restartDeeplink);
        }
    }

    void handleTargetRequestResetEvent(@NonNull Event event) {
        if (TargetUtils.isNullOrEmpty(event.getEventData())) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"handleTargetRequestResetEvent - Failed to process Target request content event, event data is null/ empty.", (Object[])new Object[0]);
            return;
        }
        Map eventData = event.getEventData();
        if (DataReader.optBoolean((Map)eventData, (String)"resetexperience", (boolean)false)) {
            this.resetIdentity(event);
            return;
        }
        if (DataReader.optBoolean((Map)eventData, (String)"clearcache", (boolean)false)) {
            this.targetState.clearPrefetchedMboxes();
        }
    }

    void handleTargetRequestIdentityEvent(@NonNull Event event) {
        Map eventData = event.getEventData();
        if (TargetUtils.isNullOrEmpty(eventData)) {
            this.dispatchIdentity(event);
            return;
        }
        if (eventData.containsKey("thirdpartyid")) {
            String thirdPartyId = DataReader.optString((Map)eventData, (String)"thirdpartyid", null);
            this.setThirdPartyIdInternal(thirdPartyId);
            this.getApi().createSharedState(this.targetState.generateSharedState(), event);
        } else if (eventData.containsKey("tntid")) {
            String tntId = DataReader.optString((Map)eventData, (String)"tntid", null);
            this.setTntIdInternal(tntId);
            this.getApi().createSharedState(this.targetState.generateSharedState(), event);
        } else if (eventData.containsKey("sessionid")) {
            String sessionId = DataReader.optString((Map)eventData, (String)"sessionid", null);
            this.setSessionId(sessionId);
        }
    }

    void handleGenericDataOSEvent(@NonNull Event event) {
        if (TargetUtils.isNullOrEmpty(event.getEventData())) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"handleGenericDataOSEvent - Failed to process Generic os event, event data is null/ empty.", (Object[])new Object[0]);
            return;
        }
        String deepLink = DataReader.optString((Map)event.getEventData(), (String)"deeplink", null);
        if (!StringUtils.isNullOrEmpty((String)deepLink)) {
            this.setupPreviewMode(deepLink);
        }
    }

    void handleConfigurationResponseContentEvent(@NonNull Event event) {
        Log.trace((String)"Target", (String)CLASS_NAME, (String)"handleConfigurationResponse - event %s type: %s source: %s ", (Object[])new Object[]{event.getName(), event.getType(), event.getSource()});
        if (this.targetState.getMobilePrivacyStatus() == MobilePrivacyStatus.OPT_OUT) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"handleConfigurationResponse - Clearing saved identities", (Object[])new Object[0]);
            this.resetIdentity();
            this.getApi().createSharedState(this.targetState.generateSharedState(), event);
        }
    }

    void setPreviewRestartDeepLink(String deepLink) {
        this.targetPreviewManager.setRestartDeepLink(deepLink);
    }

    void handleRawRequest(@NonNull Event event) {
        Log.trace((String)"Target", (String)CLASS_NAME, (String)"Processing the raw Target request - event %s type: %s source: %s ", (Object[])new Object[]{event.getName(), event.getType(), event.getSource()});
        Map eventData = event.getEventData();
        try {
            String sendRequestError;
            long environmentId;
            Map property;
            boolean isContentRequest;
            Map id = DataReader.getTypedMap(Object.class, (Map)eventData, (String)"id");
            Map context = DataReader.getTypedMap(Object.class, (Map)eventData, (String)"context");
            Map experienceCloud = DataReader.getTypedMap(Object.class, (Map)eventData, (String)"experienceCloud");
            Map execute = DataReader.getTypedMap(Object.class, (Map)eventData, (String)"execute");
            Map prefetch = DataReader.getTypedMap(Object.class, (Map)eventData, (String)"prefetch");
            List notifications = DataReader.getTypedListOfMap(Object.class, (Map)eventData, (String)"notifications");
            boolean bl = isContentRequest = prefetch != null || execute != null;
            if (this.networkService == null) {
                Log.error((String)"Target", (String)CLASS_NAME, (String)"handleRawRequest - (%s)", (Object[])new Object[]{"Unable to send target request, Network service is not available"});
                this.dispatchTargetRawResponseIfNeeded(isContentRequest, null, event);
                return;
            }
            if (this.targetRequestBuilder == null) {
                Log.error((String)"Target", (String)CLASS_NAME, (String)"handleRawRequest - (%s)", (Object[])new Object[]{"Couldn't initialize the target request builder for this request"});
                this.dispatchTargetRawResponseIfNeeded(isContentRequest, null, event);
                return;
            }
            String propertyToken = this.targetState.getPropertyToken();
            if (StringUtils.isNullOrEmpty((String)propertyToken) && !TargetUtils.isNullOrEmpty(property = DataReader.getTypedMap(Object.class, (Map)eventData, (String)"property"))) {
                propertyToken = DataReader.optString((Map)property, (String)"token", (String)"");
            }
            if ((environmentId = this.targetState.getEnvironmentId()) == 0L) {
                environmentId = DataReader.optLong((Map)eventData, (String)"environmentId", (long)0L);
            }
            if ((sendRequestError = this.prepareForTargetRequest()) != null) {
                Log.warning((String)"Target", (String)CLASS_NAME, (String)"handleRawRequest - ", (Object[])new Object[]{sendRequestError});
                this.dispatchTargetRawResponseIfNeeded(isContentRequest, null, event);
                return;
            }
            JSONObject defaultJsonObject = this.targetRequestBuilder.getDefaultJsonObject(id, context, experienceCloud, environmentId, this.retrieveIdentitySharedState(event));
            JSONObject payloadJson = this.targetRequestBuilder.getRequestPayload(defaultJsonObject, prefetch, execute, notifications, propertyToken);
            if (JSONUtils.isNullOrEmpty((JSONObject)payloadJson)) {
                Log.warning((String)"Target", (String)CLASS_NAME, (String)"handleRawRequest - Cannot send raw Target request, payload json is null or empty.", (Object[])new Object[0]);
                this.dispatchTargetRawResponseIfNeeded(isContentRequest, null, event);
                return;
            }
            Map<String, Object> eventHubData = this.retrieveEventHubSharedState(event);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("X-EXC-SDK", this.getSdkInfo(eventHubData));
            headers.put("X-EXC-SDK-Version", this.getSdkVersion(eventHubData));
            String url = this.getTargetRequestUrl();
            String payloadJsonString = payloadJson.toString();
            byte[] payload = payloadJsonString.getBytes(StandardCharsets.UTF_8);
            int timeout = this.targetState.getNetworkTimeout();
            NetworkRequest networkRequest = new NetworkRequest(url, HttpMethod.POST, payload, headers, timeout, timeout);
            Log.debug((String)"Target", (String)"handleRawRequest - Target request was sent with url %s, body %s", (String)url, (Object[])new Object[]{payloadJsonString});
            this.networkService.connectAsync(networkRequest, connection -> this.processTargetRawResponse(connection, isContentRequest, event));
        }
        catch (DataReaderException e) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"handleRawRequest - Cannot process the raw Target request, the provided request data is invalid (%s).", (Object[])new Object[]{e.getMessage()});
        }
    }

    void handleMboxPrefetch(@NonNull List<TargetPrefetch> targetPrefetchRequests, @NonNull Event event) {
        Log.trace((String)"Target", (String)CLASS_NAME, (String)"handleMboxPrefetch - Prefetched mbox event details - event %s type: %s source: %s ", (Object[])new Object[]{event.getName(), event.getType(), event.getSource()});
        if (this.inPreviewMode()) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"Target prefetch can't be used while in preview mode", (Object[])new Object[0]);
            this.dispatchMboxPrefetchResult("Target prefetch can't be used while in preview mode", event);
            return;
        }
        Map eventData = event.getEventData();
        Map targetParametersMap = DataReader.optTypedMap(Object.class, (Map)eventData, (String)"targetparams", null);
        TargetParameters targetParameters = TargetParameters.fromEventData(targetParametersMap);
        Map<String, Object> lifecycleData = this.retrieveLifecycleSharedState(event);
        Map<String, Object> identityData = this.retrieveIdentitySharedState(event);
        this.prefetchMboxContent(targetPrefetchRequests, targetParameters, lifecycleData, identityData, event);
    }

    void loadRequests(@NonNull List<TargetRequest> targetRequests, @NonNull Event event) {
        Log.trace((String)"Target", (String)CLASS_NAME, (String)"loadRequests - event %s type: %s source: %s ", (Object[])new Object[]{event.getName(), event.getType(), event.getSource()});
        Map eventData = event.getEventData();
        Map targetParametersMap = DataReader.optTypedMap(Object.class, (Map)eventData, (String)"targetparams", null);
        TargetParameters targetParameters = TargetParameters.fromEventData(targetParametersMap);
        Map<String, Object> lifecycleData = this.retrieveLifecycleSharedState(event);
        Map<String, Object> identityData = this.retrieveIdentitySharedState(event);
        this.batchRequests(targetRequests, targetParameters, lifecycleData, identityData, event);
    }

    void handleLocationsDisplayed(@NonNull Event event) {
        Log.trace((String)"Target", (String)CLASS_NAME, (String)"handleLocationsDisplayed - event %s type: %s source: %s ", (Object[])new Object[]{event.getName(), event.getType(), event.getSource()});
        String sendRequestError = this.prepareForTargetRequest();
        if (sendRequestError != null) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"Unable to send display notification: %s", (Object[])new Object[]{sendRequestError});
            return;
        }
        Map eventData = event.getEventData();
        List mboxNames = DataReader.optStringList((Map)eventData, (String)"names", null);
        if (TargetUtils.isNullOrEmpty(mboxNames)) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"Location displayed unsuccessful (%s) ", (Object[])new Object[]{"MboxNames List is either null or empty"});
            return;
        }
        Map targetParametersMap = DataReader.optTypedMap(Object.class, (Map)eventData, (String)"targetparams", null);
        TargetParameters targetParameters = TargetParameters.fromEventData(targetParametersMap);
        Map<String, Object> lifecycleData = this.retrieveLifecycleSharedState(event);
        Map<String, Object> identityData = this.retrieveIdentitySharedState(event);
        for (String mboxName : mboxNames) {
            if (StringUtils.isNullOrEmpty((String)mboxName) || this.targetState.getLoadedMbox().containsKey(mboxName)) continue;
            if (!this.targetState.getPrefetchedMbox().containsKey(mboxName)) {
                Log.debug((String)"Target", (String)CLASS_NAME, (String)"Unable to send display notification: %sNo cached mbox found for %s", (Object[])new Object[]{mboxName});
                continue;
            }
            JSONObject mboxJson = this.targetState.getPrefetchedMbox().get(mboxName);
            if (!this.addDisplayNotification(mboxName, mboxJson, targetParameters, lifecycleData, event.getTimestamp())) {
                Log.debug((String)"Target", (String)CLASS_NAME, (String)"handleLocationsDisplayed - %s mBox not added for display notification.", (Object[])new Object[]{mboxName});
                continue;
            }
            this.dispatchAnalyticsForTargetRequest(this.targetResponseParser.getAnalyticsForTargetPayload(mboxJson, this.targetState.getSessionId()));
        }
        if (this.targetState.getNotifications().isEmpty()) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"handleLocationsDisplayed - No display notifications are available to send", (Object[])new Object[0]);
            return;
        }
        this.sendTargetRequest(null, null, targetParameters, lifecycleData, identityData, event, connection -> this.processNotificationResponse(connection, event));
    }

    void handleLocationClicked(@NonNull Event event) {
        JSONObject mboxJson;
        Log.trace((String)"Target", (String)CLASS_NAME, (String)"handleLocationClicked - event %s type: %s source: %s ", (Object[])new Object[]{event.getName(), event.getType(), event.getSource()});
        String sendRequestError = this.prepareForTargetRequest();
        if (sendRequestError != null) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)("Unable to send click notification: " + sendRequestError), (Object[])new Object[0]);
            return;
        }
        Map eventData = event.getEventData();
        if (TargetUtils.isNullOrEmpty(eventData)) {
            Log.error((String)"Target", (String)CLASS_NAME, (String)"Location clicked unsuccessful, event data is null or empty ", (Object[])new Object[0]);
            return;
        }
        String mboxName = DataReader.optString((Map)eventData, (String)"name", null);
        if (StringUtils.isNullOrEmpty((String)mboxName)) {
            Log.error((String)"Target", (String)CLASS_NAME, (String)"Location clicked unsuccessful MboxName is either null or empty", (Object[])new Object[0]);
            return;
        }
        if (this.targetState.getPrefetchedMbox().containsKey(mboxName)) {
            mboxJson = this.targetState.getPrefetchedMbox().get(mboxName);
        } else if (this.targetState.getLoadedMbox().containsKey(mboxName)) {
            mboxJson = this.targetState.getLoadedMbox().get(mboxName);
        } else {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"Unable to send click notification: No cached mbox found for %s", (Object[])new Object[]{mboxName});
            return;
        }
        JSONObject clickMetric = this.targetResponseParser.getClickMetric(mboxJson);
        if (clickMetric == null) {
            Log.warning((String)"Target", (String)"Unable to send click notification: No click metric found on mbox: %s", (String)mboxName, (Object[])new Object[0]);
            return;
        }
        Map targetParametersMap = DataReader.optTypedMap(Object.class, (Map)eventData, (String)"targetparams", null);
        TargetParameters targetParameters = TargetParameters.fromEventData(targetParametersMap);
        Map<String, Object> lifecycleData = this.retrieveLifecycleSharedState(event);
        Map<String, Object> identityData = this.retrieveIdentitySharedState(event);
        if (!this.addClickedNotificationToList(mboxJson, targetParameters, lifecycleData, event.getTimestamp())) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"handleLocationClicked - %s mBox not added for click notification", (Object[])new Object[]{mboxName});
            return;
        }
        Map<String, String> clickMetricA4TParams = this.targetResponseParser.getAnalyticsForTargetPayload(clickMetric);
        if (!TargetUtils.isNullOrEmpty(clickMetricA4TParams)) {
            this.dispatchAnalyticsForTargetRequest(this.targetResponseParser.preprocessAnalyticsForTargetPayload(clickMetricA4TParams, this.targetState.getSessionId()));
        }
        this.sendTargetRequest(null, null, targetParameters, lifecycleData, identityData, event, connection -> this.processNotificationResponse(connection, event));
    }

    void resetIdentity(@NonNull Event event) {
        this.resetIdentity();
        this.getApi().createSharedState(this.targetState.generateSharedState(), event);
    }

    private String prepareForTargetRequest() {
        if (this.targetState.getClientCode().isEmpty()) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"prepareForTargetRequest - TargetRequest preparation failed because (%s)", (Object[])new Object[]{"Missing client code"});
            return "Missing client code";
        }
        if (this.targetState.getMobilePrivacyStatus() != MobilePrivacyStatus.OPT_IN) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"prepareForTargetRequest - TargetRequest preparation failed because (%s)", (Object[])new Object[]{"Privacy status is not opted in"});
            return "Privacy status is not opted in";
        }
        return null;
    }

    private String getTargetRequestUrl() {
        if (!this.targetState.getTargetServer().isEmpty()) {
            return String.format("https://%s/rest/v1/delivery/?client=%s&sessionId=%s", this.targetState.getTargetServer(), this.targetState.getClientCode(), this.targetState.getSessionId());
        }
        String edgeHost = this.targetState.getEdgeHost();
        String host = StringUtils.isNullOrEmpty((String)edgeHost) ? String.format("%s.tt.omtrdc.net", this.targetState.getClientCode()) : edgeHost;
        return String.format("https://%s/rest/v1/delivery/?client=%s&sessionId=%s", host, this.targetState.getClientCode(), this.targetState.getSessionId());
    }

    private void processTargetRawResponse(HttpConnecting connection, boolean isContentRequest, Event event) {
        if (connection == null) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"processTargetRawResponse - (%s)", (Object[])new Object[]{"Unable to open connection"});
            this.dispatchTargetRawResponseIfNeeded(isContentRequest, null, event);
            return;
        }
        try {
            JSONObject responseJson = this.targetResponseParser.parseResponseToJson(connection);
            int responseCode = connection.getResponseCode();
            connection.close();
            if (responseJson == null) {
                Log.debug((String)"Target", (String)CLASS_NAME, (String)"processTargetRawResponse - (%s)Null response Json", (Object[])new Object[0]);
                this.dispatchTargetRawResponseIfNeeded(isContentRequest, null, event);
                return;
            }
            if (responseCode != 200) {
                Log.warning((String)"Target", (String)CLASS_NAME, (String)("processTargetRawResponse - Received Target response with connection code: " + responseCode), (Object[])new Object[0]);
                String responseError = this.targetResponseParser.getErrorMessage(responseJson);
                if (!StringUtils.isNullOrEmpty((String)responseError)) {
                    Log.warning((String)"Target", (String)CLASS_NAME, (String)("Errors returned in Target response: " + responseError), (Object[])new Object[0]);
                }
                this.dispatchTargetRawResponseIfNeeded(isContentRequest, null, event);
                return;
            }
            this.targetState.updateSessionTimestamp(false);
            this.setTntIdInternal(this.targetResponseParser.getTntId(responseJson));
            this.targetState.updateEdgeHost(this.targetResponseParser.getEdgeHost(responseJson));
            this.getApi().createSharedState(this.targetState.generateSharedState(), event);
            this.dispatchTargetRawResponseIfNeeded(isContentRequest, JSONUtils.toMap((JSONObject)responseJson), event);
        }
        catch (JSONException e) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"processTargetRawResponse - (%s)Null response Json", (Object[])new Object[0]);
            this.dispatchTargetRawResponseIfNeeded(isContentRequest, null, event);
        }
    }

    private void prefetchMboxContent(List<TargetPrefetch> targetPrefetchRequests, TargetParameters targetParameters, Map<String, Object> lifecycleData, Map<String, Object> identityData, Event event) {
        if (TargetUtils.isNullOrEmpty(targetPrefetchRequests)) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"prefetchMboxContent - Unable to prefetch mbox content, Error %s", (Object[])new Object[]{"Empty or null prefetch requests list"});
            this.dispatchMboxPrefetchResult("Empty or null prefetch requests list", event);
            return;
        }
        String sendRequestError = this.prepareForTargetRequest();
        if (sendRequestError != null) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"prefetchMboxContent - Unable to prefetch mbox content, Error %s", (Object[])new Object[]{sendRequestError});
            this.dispatchMboxPrefetchResult(sendRequestError, event);
            return;
        }
        String error = this.sendTargetRequest(null, targetPrefetchRequests, targetParameters, lifecycleData, identityData, event, connection -> {
            if (connection == null) {
                Log.warning((String)"Target", (String)CLASS_NAME, (String)"prefetchMboxContent - Unable to prefetch mbox content, Error %s", (Object[])new Object[]{"Unable to open connection"});
                this.dispatchMboxPrefetchResult("Unable to open connection", event);
                return;
            }
            JSONObject responseJson = this.targetResponseParser.parseResponseToJson(connection);
            String responseError = this.targetResponseParser.getErrorMessage(responseJson);
            int responseCode = connection.getResponseCode();
            connection.close();
            if (responseJson == null) {
                Log.debug((String)"Target", (String)CLASS_NAME, (String)"prefetchMboxContent - (%s)Null response Json", (Object[])new Object[0]);
                this.dispatchMboxPrefetchResult(String.format("%s %s", "Null response Json", responseError), event);
                return;
            }
            if (!StringUtils.isNullOrEmpty((String)responseError)) {
                if (responseError.contains("Notification")) {
                    this.targetState.clearNotifications();
                }
                Log.error((String)"Target", (String)CLASS_NAME, (String)("Errors returned in Target response: " + responseError), (Object[])new Object[0]);
                this.dispatchMboxPrefetchResult("Errors returned in Target response: " + responseError, event);
                return;
            }
            if (responseCode != 200) {
                Log.warning((String)"Target", (String)CLASS_NAME, (String)"prefetchMboxContent - Unable to prefetch mbox content, Error %s", (Object[])new Object[]{"Errors returned in Target response: " + responseCode});
                this.dispatchMboxPrefetchResult("Errors returned in Target response: ", event);
                return;
            }
            this.targetState.clearNotifications();
            this.targetState.updateSessionTimestamp(false);
            this.setTntIdInternal(this.targetResponseParser.getTntId(responseJson));
            this.targetState.updateEdgeHost(this.targetResponseParser.getEdgeHost(responseJson));
            this.getApi().createSharedState(this.targetState.generateSharedState(), event);
            Map<String, JSONObject> prefetchedMboxes = this.targetResponseParser.extractPrefetchedMboxes(responseJson);
            if (TargetUtils.isNullOrEmpty(prefetchedMboxes)) {
                Log.debug((String)"Target", (String)CLASS_NAME, (String)"No prefetch mbox content in Target response", (Object[])new Object[0]);
                this.dispatchMboxPrefetchResult("No prefetch mbox content in Target response", event);
                return;
            }
            this.targetState.mergePrefetchedMboxJson(prefetchedMboxes);
            this.targetState.removeDuplicateLoadedMboxes();
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"prefetchMboxContent - Current cached mboxes : %s, size: %d", (Object[])new Object[]{Arrays.toString(this.targetState.getPrefetchedMbox().keySet().toArray()), this.targetState.getPrefetchedMbox().size()});
            this.dispatchMboxPrefetchResult(null, event);
        });
        if (!StringUtils.isNullOrEmpty((String)error)) {
            this.dispatchMboxPrefetchResult(error, event);
        }
    }

    private String sendTargetRequest(List<TargetRequest> batchRequests, List<TargetPrefetch> prefetchRequests, TargetParameters targetParameters, Map<String, Object> lifecycleData, Map<String, Object> identityData, Event event, NetworkCallback networkCallback) {
        if (this.networkService == null) {
            Log.error((String)"Target", (String)CLASS_NAME, (String)"Unable to send target request, Network service is not available", (Object[])new Object[0]);
            return "Unable to send target request, Network service is not available";
        }
        if (this.targetRequestBuilder == null) {
            Log.error((String)"Target", (String)CLASS_NAME, (String)"Couldn't initialize the target request builder for this request", (Object[])new Object[0]);
            return "Couldn't initialize the target request builder for this request";
        }
        Map<String, String> lifecycleContextData = this.getLifecycleDataForTarget(lifecycleData);
        String propertyToken = !StringUtils.isNullOrEmpty((String)this.targetState.getPropertyToken()) ? this.targetState.getPropertyToken() : DataReader.optString((Map)event.getEventData(), (String)"at_property", (String)"");
        JSONObject payloadJson = this.targetRequestBuilder.getRequestPayload(prefetchRequests, batchRequests, targetParameters, this.targetState.getNotifications(), propertyToken, identityData, lifecycleContextData);
        if (JSONUtils.isNullOrEmpty((JSONObject)payloadJson)) {
            Log.error((String)"Target", (String)CLASS_NAME, (String)"sendTargetRequest - Unable to send target request, Payload json is (%s)", (Object[])new Object[]{payloadJson == null ? "null" : "empty"});
            return "Failed to generate the Target request payload";
        }
        Map<String, Object> eventHubData = this.retrieveEventHubSharedState(event);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("X-EXC-SDK", this.getSdkInfo(eventHubData));
        headers.put("X-EXC-SDK-Version", this.getSdkVersion(eventHubData));
        int timeout = this.targetState.getNetworkTimeout();
        String url = this.getTargetRequestUrl();
        String payloadJsonString = payloadJson.toString();
        byte[] payload = payloadJsonString.getBytes(StandardCharsets.UTF_8);
        NetworkRequest networkRequest = new NetworkRequest(url, HttpMethod.POST, payload, headers, timeout, timeout);
        Log.debug((String)"Target", (String)CLASS_NAME, (String)"sendTargetRequest - Target request was sent with url %s, body %s", (Object[])new Object[]{url, payloadJsonString});
        this.networkService.connectAsync(networkRequest, networkCallback);
        return null;
    }

    private void batchRequests(List<TargetRequest> targetBatchRequests, TargetParameters targetParameters, Map<String, Object> lifecycleData, Map<String, Object> identityData, Event event) {
        List<TargetRequest> requestsToSend;
        if (TargetUtils.isNullOrEmpty(targetBatchRequests)) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"batchRequests - Unable to process the batch requests, Target Batch Requests are %s.", (Object[])new Object[]{targetBatchRequests == null ? "null" : "empty"});
            this.runDefaultCallbacks(targetBatchRequests, event);
            return;
        }
        String sendRequestError = this.prepareForTargetRequest();
        if (sendRequestError != null) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"batchRequests - Unable to process the batch requests, Error - %s", (Object[])new Object[]{sendRequestError});
            this.runDefaultCallbacks(targetBatchRequests, event);
            return;
        }
        if (!this.inPreviewMode()) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"Current cached mboxes : %s, size: %d", (Object[])new Object[]{Arrays.toString(this.targetState.getPrefetchedMbox().keySet().toArray()), this.targetState.getPrefetchedMbox().size()});
            requestsToSend = this.processCachedTargetRequest(targetBatchRequests, event);
        } else {
            requestsToSend = targetBatchRequests;
        }
        if (TargetUtils.isNullOrEmpty(requestsToSend) && this.targetState.getNotifications().isEmpty()) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"Unable to process the batch requests, requests and notifications are empty", (Object[])new Object[0]);
            return;
        }
        String error = this.sendTargetRequest(requestsToSend, null, targetParameters, lifecycleData, identityData, event, connection -> this.processTargetRequestResponse(requestsToSend, connection, event));
        if (!StringUtils.isNullOrEmpty((String)error)) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"batchRequests - Unable to open connection", (Object[])new Object[0]);
            this.runDefaultCallbacks(requestsToSend, event);
        }
    }

    List<TargetRequest> processCachedTargetRequest(List<TargetRequest> batchRequests, Event event) {
        ArrayList<TargetRequest> requestsToSend = new ArrayList<TargetRequest>();
        for (TargetRequest targetRequest : batchRequests) {
            if (!this.targetState.getPrefetchedMbox().containsKey(targetRequest.getMboxName())) {
                Log.debug((String)"Target", (String)CLASS_NAME, (String)"processCachedTargetRequest - (%s) (%s) ", (Object[])new Object[]{"No cached mbox found for %s", targetRequest.getMboxName()});
                requestsToSend.add(targetRequest);
                continue;
            }
            JSONObject cachedMboxJson = this.targetState.getPrefetchedMbox().get(targetRequest.getMboxName());
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"processCachedTargetRequest - Cached mbox found for %s with data %s", (Object[])new Object[]{targetRequest.getMboxName(), cachedMboxJson});
            String content = this.targetResponseParser.extractMboxContent(cachedMboxJson);
            Map<String, String> a4tParams = this.targetResponseParser.getAnalyticsForTargetPayload(cachedMboxJson);
            Map<String, Object> responseTokens = this.targetResponseParser.getResponseTokens(cachedMboxJson);
            Map<String, String> clickMetricA4TParams = this.targetResponseParser.extractClickMetricAnalyticsPayload(cachedMboxJson);
            this.dispatchMboxContent(StringUtils.isNullOrEmpty((String)content) ? targetRequest.getDefaultContent() : content, a4tParams, clickMetricA4TParams, responseTokens, targetRequest.getResponsePairId(), event);
        }
        return requestsToSend;
    }

    private void processTargetRequestResponse(List<TargetRequest> batchRequests, HttpConnecting connection, Event event) {
        if (connection == null) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"processTargetRequestResponse - (%s)", (Object[])new Object[]{"Unable to open connection"});
            this.runDefaultCallbacks(batchRequests, event);
            return;
        }
        JSONObject responseJson = this.targetResponseParser.parseResponseToJson(connection);
        String responseError = this.targetResponseParser.getErrorMessage(responseJson);
        int responseCode = connection.getResponseCode();
        connection.close();
        if (responseJson == null) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"processTargetRequestResponse - (%s)", (Object[])new Object[]{"Null response Json"});
            this.runDefaultCallbacks(batchRequests, event);
            return;
        }
        if (!StringUtils.isNullOrEmpty((String)responseError)) {
            if (responseError.contains("Notification")) {
                this.targetState.clearNotifications();
            }
            Log.error((String)"Target", (String)CLASS_NAME, (String)("Errors returned in Target response: " + responseError), (Object[])new Object[0]);
            this.runDefaultCallbacks(batchRequests, event);
            return;
        }
        if (responseCode != 200) {
            Log.error((String)"Target", (String)CLASS_NAME, (String)"processTargetRequestResponse - (%) Error (%s), Error code (%s)", (Object[])new Object[]{"Errors returned in Target response: ", responseError, responseCode});
            this.runDefaultCallbacks(batchRequests, event);
            return;
        }
        this.targetState.clearNotifications();
        this.targetState.updateSessionTimestamp(false);
        this.setTntIdInternal(this.targetResponseParser.getTntId(responseJson));
        this.targetState.updateEdgeHost(this.targetResponseParser.getEdgeHost(responseJson));
        this.getApi().createSharedState(this.targetState.generateSharedState(), event);
        Map<String, JSONObject> batchedMboxes = this.targetResponseParser.extractBatchedMBoxes(responseJson);
        if (TargetUtils.isNullOrEmpty(batchedMboxes)) {
            this.runDefaultCallbacks(batchRequests, event);
            return;
        }
        this.targetState.saveLoadedMbox(batchedMboxes);
        for (TargetRequest targetRequest : batchRequests) {
            if (!batchedMboxes.containsKey(targetRequest.getMboxName())) {
                this.dispatchMboxContent(targetRequest.getDefaultContent(), null, null, null, targetRequest.getResponsePairId(), event);
                continue;
            }
            JSONObject mboxJson = batchedMboxes.get(targetRequest.getMboxName());
            String content = this.targetResponseParser.extractMboxContent(mboxJson);
            Map<String, Object> responseTokens = this.targetResponseParser.getResponseTokens(mboxJson);
            Map<String, String> clickMetricA4TParams = this.targetResponseParser.extractClickMetricAnalyticsPayload(mboxJson);
            Map<String, String> a4tParams = this.targetResponseParser.getAnalyticsForTargetPayload(mboxJson);
            if (!TargetUtils.isNullOrEmpty(a4tParams)) {
                this.dispatchAnalyticsForTargetRequest(this.targetResponseParser.getAnalyticsForTargetPayload(mboxJson, this.targetState.getSessionId()));
            }
            this.dispatchMboxContent(StringUtils.isNullOrEmpty((String)content) ? targetRequest.getDefaultContent() : content, a4tParams, clickMetricA4TParams, responseTokens, targetRequest.getResponsePairId(), event);
        }
    }

    private boolean addDisplayNotification(String mboxName, JSONObject mboxJson, TargetParameters targetParameters, Map<String, Object> lifecycleData, long timestamp) {
        if (this.targetRequestBuilder == null) {
            Log.error((String)"Target", (String)CLASS_NAME, (String)"Couldn't initialize the target request builder for this request", (Object[])new Object[0]);
            return false;
        }
        Map<String, String> lifecycleContextData = this.getLifecycleDataForTarget(lifecycleData);
        JSONObject displayNotificationJson = this.targetRequestBuilder.getDisplayNotificationJsonObject(mboxName, mboxJson, targetParameters, timestamp, lifecycleContextData);
        if (displayNotificationJson == null) {
            Log.debug((String)"Target", (String)"addDisplayNotification - No display notifications are available to send for mbox %s", (String)mboxName, (Object[])new Object[0]);
            return false;
        }
        this.targetState.addNotification(displayNotificationJson);
        return true;
    }

    private void processNotificationResponse(HttpConnecting connection, Event event) {
        if (connection == null) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"processNotificationResponse - %s", (Object[])new Object[]{"Unable to open connection"});
            return;
        }
        JSONObject responseJson = this.targetResponseParser.parseResponseToJson(connection);
        String responseError = this.targetResponseParser.getErrorMessage(responseJson);
        int responseCode = connection.getResponseCode();
        connection.close();
        if (responseJson == null) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"processNotificationResponse (%s)Null response Json", (Object[])new Object[0]);
            return;
        }
        if (!StringUtils.isNullOrEmpty((String)responseError)) {
            if (responseError.contains("Notification")) {
                this.targetState.clearNotifications();
            }
            Log.error((String)"Target", (String)CLASS_NAME, (String)("Errors returned in Target response: " + responseError), (Object[])new Object[0]);
            return;
        }
        if (responseCode != 200) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"processNotificationResponseErrors returned in Target response: ", (Object[])new Object[]{responseCode});
            return;
        }
        this.targetState.clearNotifications();
        this.targetState.updateSessionTimestamp(false);
        this.setTntIdInternal(this.targetResponseParser.getTntId(responseJson));
        this.targetState.updateEdgeHost(this.targetResponseParser.getEdgeHost(responseJson));
        this.getApi().createSharedState(this.targetState.generateSharedState(), event);
    }

    private boolean addClickedNotificationToList(JSONObject mboxJson, TargetParameters targetParameters, Map<String, Object> lifecycleData, long timestamp) {
        if (this.targetRequestBuilder == null) {
            Log.error((String)"Target", (String)CLASS_NAME, (String)"Couldn't initialize the target request builder for this request", (Object[])new Object[0]);
            return false;
        }
        Map<String, String> lifecycleContextData = this.getLifecycleDataForTarget(lifecycleData);
        JSONObject clickNotificationJson = this.targetRequestBuilder.getClickNotificationJsonObject(mboxJson, targetParameters, timestamp, lifecycleContextData);
        if (clickNotificationJson == null) {
            Log.debug((String)"Target", (String)"addClickedNotificationToList - %s", (String)"No click notifications are available to send", (Object[])new Object[0]);
            return false;
        }
        this.targetState.addNotification(clickNotificationJson);
        return true;
    }

    private void setupPreviewMode(String deepLink) {
        String sendRequestError = this.prepareForTargetRequest();
        if (sendRequestError != null) {
            Log.debug((String)"Target", (String)"setupPreviewMode - Target is not enabled, cannot enter in preview mode: %s", (String)sendRequestError, (Object[])new Object[0]);
            return;
        }
        if (!this.targetState.isPreviewEnabled()) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"setupPreviewMode - Target Preview is disabled, please change the configuration and try again", (Object[])new Object[0]);
            return;
        }
        this.targetPreviewManager.enterPreviewModeWithDeepLinkParams(this.targetState.getClientCode(), deepLink);
    }

    private void dispatchTargetRawResponseIfNeeded(boolean isContentRequest, Map<String, Object> responseData, Event requestEvent) {
        if (!isContentRequest) {
            return;
        }
        this.dispatchTargetRawResponse(responseData, requestEvent);
    }

    void dispatchTargetRawResponse(Map<String, Object> responseData, Event requestEvent) {
        HashMap<String, Map<String, Object>> data = new HashMap<String, Map<String, Object>>();
        data.put("responsedata", responseData);
        Log.trace((String)"Target", (String)CLASS_NAME, (String)"dispatchTargetRawResponse - (%s) ", (Object[])new Object[]{TARGET_EVENT_DISPATCH_MESSAGE});
        Event responseEvent = new Event.Builder("TargetRawResponse", "com.adobe.eventType.target", "com.adobe.eventSource.responseContent").setEventData(data).inResponseToEvent(requestEvent).build();
        this.getApi().dispatch(responseEvent);
    }

    private void dispatchMboxPrefetchResult(String error, Event event) {
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("prefetcherror", error);
        eventData.put("prefetchresult", error == null);
        Log.trace((String)"Target", (String)CLASS_NAME, (String)"dispatchMboxContent - Dispatching - Target response content event", (Object[])new Object[0]);
        Event responseEvent = new Event.Builder("TargetPrefetchResponse", "com.adobe.eventType.target", "com.adobe.eventSource.responseContent").setEventData(eventData).inResponseToEvent(event).build();
        this.getApi().dispatch(responseEvent);
    }

    void dispatchMboxContent(String content, Map<String, String> a4tParams, Map<String, String> clickMetricA4TParams, Map<String, Object> responseTokens, String pairId, Event event) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("content", content);
        HashMap<String, Map<String, Object>> dataPayload = new HashMap<String, Map<String, Object>>();
        if (a4tParams != null) {
            dataPayload.put("analytics.payload", a4tParams);
        }
        if (responseTokens != null) {
            dataPayload.put("responseTokens", responseTokens);
        }
        if (clickMetricA4TParams != null) {
            dataPayload.put("clickmetric.analytics.payload", clickMetricA4TParams);
        }
        data.put("data", dataPayload);
        if (!StringUtils.isNullOrEmpty((String)pairId)) {
            data.put("responsePairId", pairId);
        }
        data.put("responseEventId", event.getUniqueIdentifier());
        Log.trace((String)"Target", (String)CLASS_NAME, (String)"dispatchMboxContent - Dispatching - Target response content event", (Object[])new Object[0]);
        Event responseEvent = new Event.Builder("TargetRequestResponse", "com.adobe.eventType.target", "com.adobe.eventSource.responseContent").setEventData(data).build();
        this.getApi().dispatch(responseEvent);
    }

    void dispatchAnalyticsForTargetRequest(Map<String, String> payload) {
        if (TargetUtils.isNullOrEmpty(payload)) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"dispatchAnalyticsForTargetRequest - Failed to dispatch analytics. Payload is either null or empty", (Object[])new Object[0]);
            return;
        }
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("contextdata", payload);
        eventData.put("action", "AnalyticsForTarget");
        eventData.put("trackinternal", true);
        Event analyticsForTargetEvent = new Event.Builder("AnalyticsForTargetRequest", "com.adobe.eventType.analytics", "com.adobe.eventSource.requestContent").setEventData(eventData).build();
        this.getApi().dispatch(analyticsForTargetEvent);
    }

    void dispatchIdentity(Event event) {
        HashMap<String, String> responseEventData = new HashMap<String, String>();
        if (!StringUtils.isNullOrEmpty((String)this.targetState.getThirdPartyId())) {
            responseEventData.put("thirdpartyid", this.targetState.getThirdPartyId());
        }
        if (!StringUtils.isNullOrEmpty((String)this.targetState.getTntId())) {
            responseEventData.put("tntid", this.targetState.getTntId());
        }
        responseEventData.put("sessionid", this.targetState.getSessionId());
        Event responseEvent = new Event.Builder("TargetResponseIdentity", "com.adobe.eventType.target", "com.adobe.eventSource.responseIdentity").setEventData(responseEventData).inResponseToEvent(event).build();
        this.getApi().dispatch(responseEvent);
    }

    private TargetRequestBuilder getRequestBuilder() {
        if (this.deviceInfoService == null) {
            Log.error((String)"Target", (String)CLASS_NAME, (String)"Couldn't initialize the target request builder for this request Device Info services are not available", (Object[])new Object[0]);
            return null;
        }
        return new TargetRequestBuilder(this.deviceInfoService, this.targetPreviewManager, this.targetState);
    }

    private boolean inPreviewMode() {
        String previewParams = this.targetPreviewManager.getPreviewParameters();
        return !StringUtils.isNullOrEmpty((String)previewParams);
    }

    void setTntIdInternal(String updatedTntId) {
        if (this.targetState.getMobilePrivacyStatus() == MobilePrivacyStatus.OPT_OUT && !StringUtils.isNullOrEmpty((String)updatedTntId)) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"updateTntId - Cannot update Target tntId due to opt out privacy status.", (Object[])new Object[0]);
            return;
        }
        if (this.tntIdValuesAreEqual(this.targetState.getTntId(), updatedTntId)) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"updateTntId - Won't update Target tntId as provided value is same as the existing tntId value (%s).", (Object[])new Object[]{updatedTntId});
            return;
        }
        String edgeHost = this.extractEdgeHost(updatedTntId);
        if (!StringUtils.isNullOrEmpty((String)edgeHost)) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"updateTntId - The edge host value derived from the given tntId (%s) is (%s).", (Object[])new Object[]{updatedTntId, edgeHost});
            this.targetState.updateEdgeHost(edgeHost);
        } else {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"updateTntId - The edge host value cannot be derived from the given tntId (%s) and it is removed from the data store.", (Object[])new Object[]{updatedTntId});
            this.targetState.updateEdgeHost(null);
        }
        Log.trace((String)"Target", (String)CLASS_NAME, (String)"setTntIdInternal - Updating tntId with value (%s).", (Object[])new Object[]{updatedTntId});
        this.targetState.updateTntId(updatedTntId);
    }

    void setThirdPartyIdInternal(String updatedThirdPartyId) {
        if (this.targetState.getMobilePrivacyStatus() == MobilePrivacyStatus.OPT_OUT && !StringUtils.isNullOrEmpty((String)updatedThirdPartyId)) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"setThirdPartyIdInternal - Cannot update Target thirdPartyId due to opt out privacy status.", (Object[])new Object[0]);
            return;
        }
        if (this.targetState.getThirdPartyId() != null && this.targetState.getThirdPartyId().equals(updatedThirdPartyId)) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"setThirdPartyIdInternal - New thirdPartyId value is same as the existing thirdPartyId (%s).", (Object[])new Object[]{this.targetState.getThirdPartyId()});
            return;
        }
        Log.trace((String)"Target", (String)CLASS_NAME, (String)"setThirdPartyIdInternal - Updating thirdPartyId with value (%s).", (Object[])new Object[]{updatedThirdPartyId});
        this.targetState.updateThirdPartyId(updatedThirdPartyId);
    }

    private String extractEdgeHost(String newTntId) {
        if (StringUtils.isNullOrEmpty((String)newTntId)) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"extractEdgeHost - Cannot extract Edge host from the provided tntId as it is null or empty.", (Object[])new Object[0]);
            return null;
        }
        Pattern pattern = Pattern.compile("(?<=[0-9A-Fa-f-]\\.)([\\d][^\\D]*)(?=_)");
        Matcher matcher = pattern.matcher(newTntId);
        String locationHint = null;
        if (matcher.find()) {
            locationHint = matcher.group();
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"extractEdgeHost - Provided tntId (%s) contains location hint (%s).", (Object[])new Object[]{newTntId, locationHint});
        }
        String edgeHost = null;
        if (!StringUtils.isNullOrEmpty((String)locationHint)) {
            edgeHost = String.format("%s.tt.omtrdc.net", String.format("mboxedge%s", locationHint));
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"extractEdgeHost - Edge host (%s) is derived from the provided tntId (%s).", (Object[])new Object[]{edgeHost, locationHint});
        }
        return edgeHost;
    }

    private boolean tntIdValuesAreEqual(String oldId, String newId) {
        if (oldId == null && newId == null) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"tntIdValuesAreEqual - old and new tntId is null.", (Object[])new Object[0]);
            return true;
        }
        if (oldId == null || newId == null) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"tntIdValuesAreEqual - %s is null.", (Object[])new Object[]{oldId == null ? "oldId" : "newId"});
            return false;
        }
        if (oldId.equals(newId)) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"tntIdValuesAreEqual - old tntId is equal to new tntId.", (Object[])new Object[0]);
            return true;
        }
        Log.debug((String)"Target", (String)CLASS_NAME, (String)"tntIdValuesAreEqual - old tntId is not equal to new tntId.", (Object[])new Object[0]);
        return false;
    }

    void setSessionId(String newSessionId) {
        if (this.targetState.getMobilePrivacyStatus() == MobilePrivacyStatus.OPT_OUT) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"setSessionId - Cannot update Target session id due to opted out privacy status.", (Object[])new Object[0]);
            return;
        }
        if (StringUtils.isNullOrEmpty((String)newSessionId)) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"setSessionId - Removing session information from the Data store, new session id value is null or empty.", (Object[])new Object[0]);
            this.targetState.resetSession();
            return;
        }
        if (!newSessionId.equals(this.targetState.getSessionId())) {
            this.targetState.updateSessionId(newSessionId);
        }
        this.targetState.updateSessionTimestamp(false);
    }

    private void resetIdentity() {
        this.setTntIdInternal(null);
        this.setThirdPartyIdInternal(null);
        this.targetState.updateEdgeHost(null);
        this.targetState.resetSession();
    }

    private Map<String, String> getLifecycleDataForTarget(Map<String, Object> lifecycleData) {
        if (TargetUtils.isNullOrEmpty(lifecycleData)) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"getLifecycleDataForTarget - lifecycleData is (%s)", (Object[])new Object[]{lifecycleData == null ? "null" : "empty"});
            return null;
        }
        HashMap tempLifecycleContextData = new HashMap(DataReader.optStringMap(lifecycleData, (String)"lifecyclecontextdata", null));
        HashMap<String, String> lifecycleContextData = new HashMap<String, String>();
        for (Map.Entry<String, String> kvp : TargetConstants.MAP_TO_CONTEXT_DATA_KEYS.entrySet()) {
            String value = (String)tempLifecycleContextData.get(kvp.getKey());
            if (StringUtils.isNullOrEmpty((String)value)) continue;
            lifecycleContextData.put(kvp.getValue(), value);
            tempLifecycleContextData.remove(kvp.getKey());
        }
        lifecycleContextData.putAll(tempLifecycleContextData);
        return lifecycleContextData;
    }

    private void runDefaultCallbacks(List<TargetRequest> batchRequests, Event event) {
        if (TargetUtils.isNullOrEmpty(batchRequests)) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"runDefaultCallbacks - Batch requests are (%s)", (Object[])new Object[]{batchRequests == null ? "null" : "empty"});
            return;
        }
        for (TargetRequest request : batchRequests) {
            this.dispatchMboxContent(request.getDefaultContent(), null, null, null, request.getResponsePairId(), event);
        }
    }

    private String getSdkVersion(Map<String, Object> eventHubData) {
        if (TargetUtils.isNullOrEmpty(eventHubData)) {
            return "";
        }
        String coreVersion = DataReader.optString(eventHubData, (String)"version", (String)"unknown");
        return String.format("%s+%s", coreVersion, Target.extensionVersion());
    }

    private String getSdkInfo(Map<String, Object> eventHubData) {
        String sdkBase = "AdobeTargetMobile-Android";
        if (TargetUtils.isNullOrEmpty(eventHubData)) {
            return "AdobeTargetMobile-Android";
        }
        Map wrapperMap = DataReader.optTypedMap(Object.class, eventHubData, (String)"wrapper", null);
        if (TargetUtils.isNullOrEmpty(wrapperMap)) {
            return "AdobeTargetMobile-Android";
        }
        String wrapperFriendlyName = DataReader.optString((Map)wrapperMap, (String)"friendlyName", (String)"None");
        if (wrapperFriendlyName.equals("None")) {
            return "AdobeTargetMobile-Android";
        }
        return String.format("%s-%s", "AdobeTargetMobile-Android", wrapperFriendlyName);
    }

    private Map<String, Object> retrieveLifecycleSharedState(Event event) {
        SharedStateResult lifecycleSharedState = this.getApi().getSharedState("com.adobe.module.lifecycle", event, false, SharedStateResolution.ANY);
        return lifecycleSharedState != null ? lifecycleSharedState.getValue() : null;
    }

    private Map<String, Object> retrieveIdentitySharedState(Event event) {
        SharedStateResult identitySharedState = this.getApi().getSharedState("com.adobe.module.identity", event, false, SharedStateResolution.ANY);
        return identitySharedState != null ? identitySharedState.getValue() : null;
    }

    private Map<String, Object> retrieveConfigurationSharedState(Event event) {
        SharedStateResult configSharedState = this.getApi().getSharedState("com.adobe.module.configuration", event, false, SharedStateResolution.ANY);
        return configSharedState != null ? configSharedState.getValue() : null;
    }

    private Map<String, Object> retrieveEventHubSharedState(Event event) {
        SharedStateResult eventHubSharedState = this.getApi().getSharedState("com.adobe.module.eventhub", event, false, SharedStateResolution.ANY);
        return eventHubSharedState != null ? eventHubSharedState.getValue() : null;
    }
}

