/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder.internal.builders;

import android.app.Activity;
import android.app.NotificationManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.widget.RemoteViews;
import androidx.core.app.NotificationCompat;
import com.adobe.marketing.mobile.notificationbuilder.NotificationConstructionFailedException;
import com.adobe.marketing.mobile.notificationbuilder.R;
import com.adobe.marketing.mobile.notificationbuilder.internal.PushTemplateImageUtils;
import com.adobe.marketing.mobile.notificationbuilder.internal.builders.AEPPushNotificationBuilder;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.NotificationManagerExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.ZeroBezelPushTemplate;
import com.adobe.marketing.mobile.services.Log;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/builders/ZeroBezelNotificationBuilder;", "", "()V", "SELF_TAG", "", "construct", "Landroidx/core/app/NotificationCompat$Builder;", "context", "Landroid/content/Context;", "pushTemplate", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/ZeroBezelPushTemplate;", "trackerActivityClass", "Ljava/lang/Class;", "Landroid/app/Activity;", "notificationbuilder_phoneRelease"})
public final class ZeroBezelNotificationBuilder {
    @NotNull
    public static final ZeroBezelNotificationBuilder INSTANCE = new ZeroBezelNotificationBuilder();
    @NotNull
    private static final String SELF_TAG = "ZeroBezelNotificationBuilder";

    private ZeroBezelNotificationBuilder() {
    }

    @NotNull
    public final NotificationCompat.Builder construct(@NotNull Context context, @NotNull ZeroBezelPushTemplate pushTemplate, @Nullable Class<? extends Activity> trackerActivityClass) throws NotificationConstructionFailedException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pushTemplate, (String)"pushTemplate");
        Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)"Building a zero bezel template push notification.", (Object[])new Object[0]);
        String packageName = context.getPackageName();
        RemoteViews smallLayout = new RemoteViews(packageName, R.layout.push_template_zero_bezel_collapsed);
        RemoteViews expandedLayout = new RemoteViews(packageName, R.layout.push_template_zero_bezel_expanded);
        int downloadedImageCount = PushTemplateImageUtils.INSTANCE.cacheImages$notificationbuilder_phoneRelease(CollectionsKt.listOf((Object)pushTemplate.getImageUrl$notificationbuilder_phoneRelease()));
        if (downloadedImageCount > 0) {
            Bitmap pushImage = PushTemplateImageUtils.INSTANCE.getCachedImage$notificationbuilder_phoneRelease(pushTemplate.getImageUrl$notificationbuilder_phoneRelease());
            expandedLayout.setImageViewBitmap(R.id.expanded_template_image, pushImage);
            if (pushTemplate.getCollapsedStyle$notificationbuilder_phoneRelease() == ZeroBezelPushTemplate.ZeroBezelStyle.IMAGE) {
                smallLayout.setImageViewBitmap(R.id.collapsed_template_image, pushImage);
            } else {
                smallLayout.setViewVisibility(R.id.collapsed_template_image, 8);
                smallLayout.setViewVisibility(R.id.gradient_template_image, 8);
            }
        } else {
            Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)"No image found for zero bezel push template.", (Object[])new Object[0]);
            expandedLayout.setViewVisibility(R.id.expanded_template_image, 8);
            expandedLayout.setViewVisibility(R.id.gradient_template_image, 8);
            smallLayout.setViewVisibility(R.id.collapsed_template_image, 8);
            smallLayout.setViewVisibility(R.id.gradient_template_image, 8);
        }
        Object object = context.getSystemService("notification");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
        NotificationManager notificationManager = (NotificationManager)object;
        String channelIdToUse = NotificationManagerExtensionsKt.createNotificationChannelIfRequired(notificationManager, context, pushTemplate);
        return AEPPushNotificationBuilder.INSTANCE.construct(context, pushTemplate, channelIdToUse, trackerActivityClass, smallLayout, expandedLayout, R.id.zero_bezel_expanded_layout);
    }
}

