/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder.internal.builders;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.SystemClock;
import android.service.notification.StatusBarNotification;
import android.widget.RemoteViews;
import androidx.core.app.NotificationCompat;
import com.adobe.marketing.mobile.notificationbuilder.NotificationConstructionFailedException;
import com.adobe.marketing.mobile.notificationbuilder.R;
import com.adobe.marketing.mobile.notificationbuilder.internal.PendingIntentUtils;
import com.adobe.marketing.mobile.notificationbuilder.internal.builders.AEPPushNotificationBuilder;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.NotificationManagerExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.RemoteViewsExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.TimerPushTemplate;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.TimeUtils;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\n2\u0010\u0010\f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\nJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J$\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J*\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/builders/TimerNotificationBuilder;", "", "()V", "construct", "Landroidx/core/app/NotificationCompat$Builder;", "context", "Landroid/content/Context;", "template", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/TimerPushTemplate;", "trackerActivityClass", "Ljava/lang/Class;", "Landroid/app/Activity;", "broadcastReceiverClass", "Landroid/content/BroadcastReceiver;", "createIntent", "Landroid/content/Intent;", "initializeLayouts", "Lkotlin/Pair;", "Landroid/widget/RemoteViews;", "isExpired", "", "isExactAlarmsAllowed", "setTimerClock", "", "smallLayout", "expandedLayout", "remainingTime", "", "timerColor", "", "notificationbuilder_phoneRelease"})
@SourceDebugExtension(value={"SMAP\nTimerNotificationBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimerNotificationBuilder.kt\ncom/adobe/marketing/mobile/notificationbuilder/internal/builders/TimerNotificationBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n1#2:196\n*E\n"})
public final class TimerNotificationBuilder {
    @NotNull
    public static final TimerNotificationBuilder INSTANCE = new TimerNotificationBuilder();

    private TimerNotificationBuilder() {
    }

    @NotNull
    public final NotificationCompat.Builder construct(@NotNull Context context, @NotNull TimerPushTemplate template, @Nullable Class<? extends Activity> trackerActivityClass, @Nullable Class<? extends BroadcastReceiver> broadcastReceiverClass) throws NotificationConstructionFailedException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        if (Build.VERSION.SDK_INT < 24) {
            throw new NotificationConstructionFailedException("Timer push notification on devices below Android N is not supported.");
        }
        if (!this.isExactAlarmsAllowed(context)) {
            throw new NotificationConstructionFailedException("Exact alarms are not allowed on this device. Ignoring to build Timer template push notifications.");
        }
        Log.trace((String)"PushTemplates", (String)"TimerNotificationBuilder", (String)"Building a timer template push notification.", (Object[])new Object[0]);
        Object object = context.getSystemService("notification");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
        NotificationManager notificationManager = (NotificationManager)object;
        String channelIdToUse = NotificationManagerExtensionsKt.createNotificationChannelIfRequired(notificationManager, context, template);
        boolean isExpired = template.isExpired$notificationbuilder_phoneRelease();
        Pair<RemoteViews, RemoteViews> pair = this.initializeLayouts(context, isExpired);
        RemoteViews smallLayout = (RemoteViews)pair.component1();
        RemoteViews expandedLayout = (RemoteViews)pair.component2();
        NotificationCompat.Builder notificationBuilder = AEPPushNotificationBuilder.INSTANCE.construct(context, template, channelIdToUse, trackerActivityClass, smallLayout, expandedLayout, R.id.basic_expanded_layout);
        smallLayout.setTextViewText(R.id.notification_title, (CharSequence)template.getTimerContent$notificationbuilder_phoneRelease().getTitle());
        smallLayout.setTextViewText(R.id.notification_body, (CharSequence)template.getTimerContent$notificationbuilder_phoneRelease().getBody());
        expandedLayout.setTextViewText(R.id.notification_title, (CharSequence)template.getTimerContent$notificationbuilder_phoneRelease().getTitle());
        expandedLayout.setTextViewText(R.id.notification_body_expanded, (CharSequence)template.getTimerContent$notificationbuilder_phoneRelease().getExpandedBody());
        RemoteViewsExtensionsKt.setRemoteViewImage(expandedLayout, template.getTimerContent$notificationbuilder_phoneRelease().getImageUrl(), R.id.expanded_template_image);
        if (!isExpired) {
            long remainingTimeInSeconds = template.getExpiryTime$notificationbuilder_phoneRelease() - TimeUtils.getUnixTimeInSeconds();
            this.setTimerClock(smallLayout, expandedLayout, remainingTimeInSeconds, template.getTimerColor$notificationbuilder_phoneRelease());
            Intent intent = this.createIntent(template);
            Class<? extends BroadcastReceiver> clazz = broadcastReceiverClass;
            if (clazz != null) {
                Class<? extends BroadcastReceiver> it = clazz;
                boolean bl = false;
                intent.setClass(context, broadcastReceiverClass);
            }
            PendingIntentUtils.INSTANCE.scheduleNotification$notificationbuilder_phoneRelease(context, intent, broadcastReceiverClass, TimeUtils.getUnixTimeInSeconds() + remainingTimeInSeconds);
        } else {
            Object object2;
            block7: {
                StatusBarNotification[] statusBarNotificationArray = notificationManager.getActiveNotifications();
                Intrinsics.checkNotNullExpressionValue((Object)statusBarNotificationArray, (String)"notificationManager.activeNotifications");
                for (Object object3 : (Object[])statusBarNotificationArray) {
                    StatusBarNotification it = (StatusBarNotification)object3;
                    boolean bl = false;
                    String string = template.getTag$notificationbuilder_phoneRelease();
                    boolean bl2 = string != null ? it.getId() == string.hashCode() : false;
                    if (!bl2) continue;
                    object2 = object3;
                    break block7;
                }
                object2 = null;
            }
            StatusBarNotification notification = (StatusBarNotification)object2;
            if (notification == null) {
                Log.debug((String)"PushTemplates", (String)"TimerNotificationBuilder", (String)("Notification with tag '" + template.getTag$notificationbuilder_phoneRelease() + "' is not present in the system tray. The timer notification has already been dismissed. The expired view will not be displayed."), (Object[])new Object[0]);
                throw new NotificationConstructionFailedException("Timer Notification cancelled. Expired view will not be displayed.");
            }
        }
        return notificationBuilder;
    }

    private final Pair<RemoteViews, RemoteViews> initializeLayouts(Context context, boolean isExpired) {
        String packageName = context.getPackageName();
        int smallLayoutRes = isExpired ? R.layout.push_template_collapsed : R.layout.push_template_timer_collapsed;
        int expandedLayoutRes = isExpired ? R.layout.push_template_expanded : R.layout.push_template_timer_expanded;
        RemoteViews smallLayout = new RemoteViews(packageName, smallLayoutRes);
        RemoteViews expandedLayout = new RemoteViews(packageName, expandedLayoutRes);
        return TuplesKt.to((Object)smallLayout, (Object)expandedLayout);
    }

    private final void setTimerClock(RemoteViews smallLayout, RemoteViews expandedLayout, long remainingTime, String timerColor) {
        long remainingTimeWithSystemClock = SystemClock.elapsedRealtime() + remainingTime * (long)1000;
        smallLayout.setChronometer(R.id.timer_text, remainingTimeWithSystemClock, null, true);
        expandedLayout.setChronometer(R.id.timer_text, remainingTimeWithSystemClock, null, true);
        RemoteViewsExtensionsKt.setTimerTextColor(smallLayout, timerColor, R.id.timer_text);
        RemoteViewsExtensionsKt.setTimerTextColor(expandedLayout, timerColor, R.id.timer_text);
        if (Build.VERSION.SDK_INT >= 24) {
            smallLayout.setChronometerCountDown(R.id.timer_text, true);
            expandedLayout.setChronometerCountDown(R.id.timer_text, true);
        }
    }

    private final Intent createIntent(TimerPushTemplate template) {
        Intent intent = AEPPushNotificationBuilder.INSTANCE.createIntent$notificationbuilder_phoneRelease("timer_expired", template);
        intent.removeExtra("adb_tmr_dur");
        intent.removeExtra("adb_tmr_end");
        return intent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isExactAlarmsAllowed(Context context) {
        if (Build.VERSION.SDK_INT < 31) return true;
        Object object = context.getSystemService("alarm");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.AlarmManager");
        if (!((AlarmManager)object).canScheduleExactAlarms()) return false;
        return true;
    }
}

