/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder.internal.builders;

import android.app.Activity;
import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.graphics.Bitmap;
import android.widget.RemoteViews;
import androidx.annotation.VisibleForTesting;
import androidx.core.app.NotificationCompat;
import com.adobe.marketing.mobile.notificationbuilder.R;
import com.adobe.marketing.mobile.notificationbuilder.internal.PushTemplateImageUtils;
import com.adobe.marketing.mobile.notificationbuilder.internal.builders.AEPPushNotificationBuilder;
import com.adobe.marketing.mobile.notificationbuilder.internal.builders.BasicNotificationBuilder;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.NotificationManagerExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.RemoteViewsExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.AutoCarouselPushTemplate;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.CarouselPushTemplate;
import com.adobe.marketing.mobile.services.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\f2\u0010\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\fJU\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u0001\u00a2\u0006\u0002\b\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/builders/AutoCarouselNotificationBuilder;", "", "()V", "SELF_TAG", "", "construct", "Landroidx/core/app/NotificationCompat$Builder;", "context", "Landroid/content/Context;", "pushTemplate", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/AutoCarouselPushTemplate;", "trackerActivityClass", "Ljava/lang/Class;", "Landroid/app/Activity;", "broadcastReceiverClass", "Landroid/content/BroadcastReceiver;", "populateAutoCarouselImages", "", "expandedLayout", "Landroid/widget/RemoteViews;", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/CarouselPushTemplate;", "items", "", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/CarouselPushTemplate$CarouselItem;", "packageName", "populateAutoCarouselImages$notificationbuilder_phoneRelease", "notificationbuilder_phoneRelease"})
@SourceDebugExtension(value={"SMAP\nAutoCarouselNotificationBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoCarouselNotificationBuilder.kt\ncom/adobe/marketing/mobile/notificationbuilder/internal/builders/AutoCarouselNotificationBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n1549#2:154\n1620#2,3:155\n*S KotlinDebug\n*F\n+ 1 AutoCarouselNotificationBuilder.kt\ncom/adobe/marketing/mobile/notificationbuilder/internal/builders/AutoCarouselNotificationBuilder\n*L\n52#1:154\n52#1:155,3\n*E\n"})
public final class AutoCarouselNotificationBuilder {
    @NotNull
    public static final AutoCarouselNotificationBuilder INSTANCE = new AutoCarouselNotificationBuilder();
    @NotNull
    private static final String SELF_TAG = "AutoCarouselNotificationBuilder";

    private AutoCarouselNotificationBuilder() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NotificationCompat.Builder construct(@NotNull Context context, @NotNull AutoCarouselPushTemplate pushTemplate, @Nullable Class<? extends Activity> trackerActivityClass, @Nullable Class<? extends BroadcastReceiver> broadcastReceiverClass) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pushTemplate, (String)"pushTemplate");
        Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)"Building an auto carousel template push notification.", (Object[])new Object[0]);
        String packageName = context.getPackageName();
        RemoteViews smallLayout = new RemoteViews(packageName, R.layout.push_template_collapsed);
        RemoteViews expandedLayout = new RemoteViews(packageName, R.layout.push_template_auto_carousel);
        Iterable iterable = pushTemplate.getCarouselItems$notificationbuilder_phoneRelease();
        PushTemplateImageUtils pushTemplateImageUtils = PushTemplateImageUtils.INSTANCE;
        boolean $i$f$map = false;
        void var11_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CarouselPushTemplate.CarouselItem carouselItem = (CarouselPushTemplate.CarouselItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getImageUri());
        }
        int downloadedImageCount = pushTemplateImageUtils.cacheImages$notificationbuilder_phoneRelease((List)destination$iv$iv);
        if (downloadedImageCount < 3) {
            Log.warning((String)"PushTemplates", (String)SELF_TAG, (String)"Less than 3 images are available for the auto carousel push template, falling back to a basic push template.", (Object[])new Object[0]);
            return BasicNotificationBuilder.INSTANCE.fallbackToBasicNotification$notificationbuilder_phoneRelease(context, trackerActivityClass, broadcastReceiverClass, pushTemplate.getData());
        }
        this.populateAutoCarouselImages$notificationbuilder_phoneRelease(context, trackerActivityClass, expandedLayout, pushTemplate, pushTemplate.getCarouselItems$notificationbuilder_phoneRelease(), packageName);
        Object object = context.getSystemService("notification");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
        NotificationManager notificationManager = (NotificationManager)object;
        String channelIdToUse = NotificationManagerExtensionsKt.createNotificationChannelIfRequired(notificationManager, context, pushTemplate);
        return AEPPushNotificationBuilder.INSTANCE.construct(context, pushTemplate, channelIdToUse, trackerActivityClass, smallLayout, expandedLayout, R.id.carousel_container_layout);
    }

    @VisibleForTesting(otherwise=2)
    @NotNull
    public final List<String> populateAutoCarouselImages$notificationbuilder_phoneRelease(@NotNull Context context, @Nullable Class<? extends Activity> trackerActivityClass, @NotNull RemoteViews expandedLayout, @NotNull CarouselPushTemplate pushTemplate, @NotNull List<CarouselPushTemplate.CarouselItem> items, @Nullable String packageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)expandedLayout, (String)"expandedLayout");
        Intrinsics.checkNotNullParameter((Object)pushTemplate, (String)"pushTemplate");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        List downloadedImageUris = new ArrayList();
        for (CarouselPushTemplate.CarouselItem item : items) {
            String imageUri = item.getImageUri();
            Bitmap pushImage = PushTemplateImageUtils.INSTANCE.getCachedImage$notificationbuilder_phoneRelease(imageUri);
            if (pushImage == null) {
                Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)("Failed to retrieve an image from " + imageUri + ", will not create a new carousel item."), (Object[])new Object[0]);
                continue;
            }
            RemoteViews carouselItem = new RemoteViews(packageName, R.layout.push_template_carousel_item);
            downloadedImageUris.add(imageUri);
            carouselItem.setImageViewBitmap(R.id.carousel_item_image_view, pushImage);
            carouselItem.setTextViewText(R.id.carousel_item_caption, (CharSequence)item.getCaptionText());
            if (trackerActivityClass != null) {
                boolean bl = false;
                String string = item.getInteractionUri();
                if (string == null) {
                    string = pushTemplate.getActionUri$notificationbuilder_phoneRelease();
                }
                String interactionUri = string;
                RemoteViewsExtensionsKt.setRemoteViewClickAction(carouselItem, context, trackerActivityClass, R.id.carousel_item_image_view, interactionUri, null, null, pushTemplate.getData().getBundle());
            }
            expandedLayout.addView(R.id.auto_carousel_view_flipper, carouselItem);
        }
        return downloadedImageUris;
    }
}

