/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder.internal;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import com.adobe.marketing.mobile.notificationbuilder.PushTemplateConstants;
import com.adobe.marketing.mobile.services.Log;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0002JQ\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0010\u0010\u000f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0011\u0018\u00010\u00102\b\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\u0017\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ7\u0010\u001d\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\b2\u0010\u0010\u001f\u001a\f\u0012\u0006\b\u0001\u0012\u00020 \u0018\u00010\u00102\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b#R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/PendingIntentUtils;", "", "()V", "SELF_TAG", "", "addActionDetailsToIntent", "", "intent", "Landroid/content/Intent;", "actionUri", "actionId", "createPendingIntentForTrackerActivity", "Landroid/app/PendingIntent;", "context", "Landroid/content/Context;", "trackerActivityClass", "Ljava/lang/Class;", "Landroid/app/Activity;", "actionID", "actionType", "Lcom/adobe/marketing/mobile/notificationbuilder/PushTemplateConstants$ActionType;", "intentExtras", "Landroid/os/Bundle;", "createPendingIntentForTrackerActivity$notificationbuilder_phoneRelease", "isExactAlarmsAllowed", "", "alarmManager", "Landroid/app/AlarmManager;", "isExactAlarmsAllowed$notificationbuilder_phoneRelease", "scheduleNotification", "scheduledIntent", "broadcastReceiverClass", "Landroid/content/BroadcastReceiver;", "triggerAtSeconds", "", "scheduleNotification$notificationbuilder_phoneRelease", "notificationbuilder_phoneRelease"})
@SourceDebugExtension(value={"SMAP\nPendingIntentUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PendingIntentUtils.kt\ncom/adobe/marketing/mobile/notificationbuilder/internal/PendingIntentUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
public final class PendingIntentUtils {
    @NotNull
    public static final PendingIntentUtils INSTANCE = new PendingIntentUtils();
    @NotNull
    private static final String SELF_TAG = "PendingIntentUtils";

    private PendingIntentUtils() {
    }

    public final void scheduleNotification$notificationbuilder_phoneRelease(@NotNull Context context, @NotNull Intent scheduledIntent, @Nullable Class<? extends BroadcastReceiver> broadcastReceiverClass, long triggerAtSeconds) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)scheduledIntent, (String)"scheduledIntent");
        Class<? extends BroadcastReceiver> clazz = broadcastReceiverClass;
        if (clazz != null) {
            Class<? extends BroadcastReceiver> it = clazz;
            boolean bl = false;
            scheduledIntent.setClass(context, broadcastReceiverClass);
        }
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)new Random().nextInt(), (Intent)scheduledIntent, (int)0xA000000);
        Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"getBroadcast(\n          \u2026_UPDATE_CURRENT\n        )");
        PendingIntent pendingIntent2 = pendingIntent;
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        if (alarmManager == null) {
            return;
        }
        AlarmManager alarmManager2 = alarmManager;
        if (this.isExactAlarmsAllowed$notificationbuilder_phoneRelease(alarmManager2)) {
            Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)"Exact alarms are permitted, scheduling an exact alarm for the current notification.", (Object[])new Object[0]);
            if (Build.VERSION.SDK_INT >= 23) {
                alarmManager2.setExactAndAllowWhileIdle(0, triggerAtSeconds * (long)1000, pendingIntent2);
            } else {
                alarmManager2.setExact(0, triggerAtSeconds * (long)1000, pendingIntent2);
            }
        } else {
            Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)"Exact alarms are not permitted, scheduling an inexact alarm for the current notification.", (Object[])new Object[0]);
            alarmManager2.setAndAllowWhileIdle(0, triggerAtSeconds * (long)1000, pendingIntent2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isExactAlarmsAllowed$notificationbuilder_phoneRelease(@Nullable AlarmManager alarmManager) {
        if (Build.VERSION.SDK_INT < 31) return true;
        AlarmManager alarmManager2 = alarmManager;
        if (alarmManager2 == null) return false;
        boolean bl = alarmManager2.canScheduleExactAlarms();
        if (!bl) return false;
        return true;
    }

    @Nullable
    public final PendingIntent createPendingIntentForTrackerActivity$notificationbuilder_phoneRelease(@NotNull Context context, @Nullable Class<? extends Activity> trackerActivityClass, @Nullable String actionUri, @Nullable String actionID, @Nullable PushTemplateConstants.ActionType actionType, @Nullable Bundle intentExtras) {
        Bundle it;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent intent = PushTemplateConstants.ActionType.DISMISS == actionType ? new Intent("Notification Dismissed") : new Intent("Notification Clicked");
        Bundle bundle = trackerActivityClass;
        if (bundle != null) {
            it = bundle;
            boolean bl = false;
            intent.setClass(context.getApplicationContext(), trackerActivityClass);
        }
        intent.setFlags(0x24000000);
        Bundle bundle2 = intentExtras;
        if (bundle2 != null) {
            it = bundle2;
            boolean bl = false;
            intent.putExtras(intentExtras);
        }
        this.addActionDetailsToIntent(intent, actionUri, actionID);
        return PendingIntent.getActivity((Context)context, (int)new Random().nextInt(), (Intent)intent, (int)0xC000000);
    }

    private final void addActionDetailsToIntent(Intent intent, String actionUri, String actionId) {
        CharSequence charSequence = actionUri;
        if (!(charSequence == null || charSequence.length() == 0)) {
            intent.putExtra("actionUri", actionUri);
        }
        if (!((charSequence = (CharSequence)actionId) == null || charSequence.length() == 0)) {
            intent.putExtra("actionId", actionId);
        }
    }
}

