/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.lifecycle;

import com.adobe.marketing.mobile.lifecycle.LifecycleUtil;
import com.adobe.marketing.mobile.lifecycle.XDMLifecycleApplication;
import com.adobe.marketing.mobile.lifecycle.XDMLifecycleDevice;
import com.adobe.marketing.mobile.lifecycle.XDMLifecycleEnvironment;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

class XDMLifecycleMobileDetails {
    private XDMLifecycleApplication application;
    private XDMLifecycleDevice device;
    private XDMLifecycleEnvironment environment;
    private String eventType;
    private Date timestamp;

    XDMLifecycleMobileDetails() {
    }

    Map<String, Object> serializeToXdm() {
        Map<String, Object> environmentData;
        Map<String, Object> deviceData;
        Map<String, Object> applicationData;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.application != null && (applicationData = this.application.serializeToXdm()) != null && !applicationData.isEmpty()) {
            map.put("application", applicationData);
        }
        if (this.device != null && (deviceData = this.device.serializeToXdm()) != null && !deviceData.isEmpty()) {
            map.put("device", deviceData);
        }
        if (this.environment != null && (environmentData = this.environment.serializeToXdm()) != null && !environmentData.isEmpty()) {
            map.put("environment", environmentData);
        }
        if (this.eventType != null) {
            map.put("eventType", this.eventType);
        }
        if (this.timestamp != null) {
            map.put("timestamp", LifecycleUtil.dateTimeISO8601String(this.timestamp));
        }
        return map;
    }

    XDMLifecycleApplication getApplication() {
        return this.application;
    }

    void setApplication(XDMLifecycleApplication newValue) {
        this.application = newValue;
    }

    XDMLifecycleDevice getDevice() {
        return this.device;
    }

    void setDevice(XDMLifecycleDevice newValue) {
        this.device = newValue;
    }

    XDMLifecycleEnvironment getEnvironment() {
        return this.environment;
    }

    void setEnvironment(XDMLifecycleEnvironment newValue) {
        this.environment = newValue;
    }

    String getEventType() {
        return this.eventType;
    }

    void setEventType(String newValue) {
        this.eventType = newValue;
    }

    Date getTimestamp() {
        return this.timestamp;
    }

    void setTimestamp(Date newValue) {
        this.timestamp = newValue;
    }
}

