/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.lifecycle;

import com.adobe.marketing.mobile.lifecycle.XDMLanguage;
import com.adobe.marketing.mobile.lifecycle.XDMLifecycleEnvironmentTypeEnum;
import com.adobe.marketing.mobile.services.Log;
import java.util.HashMap;
import java.util.Map;

class XDMLifecycleEnvironment {
    private final String LOG_SOURCE = "XDMLifecycleEnvironment";
    private String carrier;
    private XDMLanguage language;
    private String operatingSystem;
    private String operatingSystemVersion;
    private XDMLifecycleEnvironmentTypeEnum type;

    XDMLifecycleEnvironment() {
    }

    Map<String, Object> serializeToXdm() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.carrier != null) {
            map.put("carrier", this.carrier);
        }
        if (this.language != null) {
            map.put("_dc", this.language.serializeToXdm());
        }
        if (this.operatingSystem != null) {
            map.put("operatingSystem", this.operatingSystem);
        }
        if (this.operatingSystemVersion != null) {
            map.put("operatingSystemVersion", this.operatingSystemVersion);
        }
        if (this.type != null) {
            map.put("type", this.type.toString());
        }
        return map;
    }

    String getCarrier() {
        return this.carrier;
    }

    void setCarrier(String newValue) {
        this.carrier = newValue;
    }

    String getLanguage() {
        return this.language != null ? this.language.getLanguage() : null;
    }

    void setLanguage(String newValue) {
        try {
            this.language = new XDMLanguage(newValue);
        }
        catch (IllegalArgumentException ex) {
            Log.warning((String)"Lifecycle", (String)"XDMLifecycleEnvironment", (String)"Language tag '%s' failed validation and will be dropped. Values for XDM field 'environment._dc.language' must conform to BCP 47.", (Object[])new Object[]{newValue});
        }
    }

    String getOperatingSystem() {
        return this.operatingSystem;
    }

    void setOperatingSystem(String newValue) {
        this.operatingSystem = newValue;
    }

    String getOperatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    void setOperatingSystemVersion(String newValue) {
        this.operatingSystemVersion = newValue;
    }

    XDMLifecycleEnvironmentTypeEnum getType() {
        return this.type;
    }

    void setType(XDMLifecycleEnvironmentTypeEnum newValue) {
        this.type = newValue;
    }
}

