/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.lifecycle;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.Extension;
import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.Lifecycle;
import com.adobe.marketing.mobile.SharedStateResolution;
import com.adobe.marketing.mobile.SharedStateResult;
import com.adobe.marketing.mobile.SharedStateStatus;
import com.adobe.marketing.mobile.lifecycle.LifecycleV1Extension;
import com.adobe.marketing.mobile.lifecycle.LifecycleV2Extension;
import com.adobe.marketing.mobile.services.DeviceInforming;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NamedCollection;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.util.DataReader;
import java.util.Map;

public class LifecycleExtension
extends Extension {
    private static final String SELF_LOG_TAG = "LifecycleExtension";
    private final NamedCollection lifecycleDataStore;
    private final LifecycleV1Extension lifecycleV1;
    private final LifecycleV2Extension lifecycleV2;

    protected LifecycleExtension(ExtensionApi extensionApi) {
        this(extensionApi, ServiceProvider.getInstance().getDataStoreService().getNamedCollection("AdobeMobile_Lifecycle"), ServiceProvider.getInstance().getDeviceInfoService());
    }

    @VisibleForTesting
    protected LifecycleExtension(ExtensionApi extensionApi, NamedCollection namedCollection, DeviceInforming deviceInfoService) {
        this(extensionApi, namedCollection, new LifecycleV1Extension(namedCollection, deviceInfoService, extensionApi), new LifecycleV2Extension(namedCollection, deviceInfoService, extensionApi));
    }

    @VisibleForTesting
    protected LifecycleExtension(ExtensionApi extensionApi, NamedCollection namedCollection, LifecycleV1Extension lifecycleV1Extension, LifecycleV2Extension lifecycleV2Extension) {
        super(extensionApi);
        this.lifecycleDataStore = namedCollection;
        this.lifecycleV1 = lifecycleV1Extension;
        this.lifecycleV2 = lifecycleV2Extension;
    }

    @NonNull
    protected String getName() {
        return "com.adobe.module.lifecycle";
    }

    protected String getVersion() {
        return Lifecycle.extensionVersion();
    }

    protected String getFriendlyName() {
        return "Lifecycle";
    }

    protected void onRegistered() {
        this.getApi().registerEventListener("com.adobe.eventType.generic.lifecycle", "com.adobe.eventSource.requestContent", this::handleLifecycleRequestEvent);
        this.getApi().registerEventListener("com.adobe.eventType._wildcard_", "com.adobe.eventSource._wildcard_", this::updateLastKnownTimestamp);
        this.lifecycleV1.onRegistered();
    }

    public boolean readyForEvent(Event event) {
        if (event.getType().equalsIgnoreCase("com.adobe.eventType.generic.lifecycle") && event.getSource().equalsIgnoreCase("com.adobe.eventSource.requestContent")) {
            SharedStateResult configurationSharedState = this.getApi().getSharedState("com.adobe.module.configuration", event, false, SharedStateResolution.ANY);
            return configurationSharedState != null && configurationSharedState.getStatus() == SharedStateStatus.SET;
        }
        return true;
    }

    void handleLifecycleRequestEvent(Event event) {
        SharedStateResult configurationSharedState = this.getApi().getSharedState("com.adobe.module.configuration", event, false, SharedStateResolution.ANY);
        if (configurationSharedState == null || configurationSharedState.getStatus() == SharedStateStatus.PENDING) {
            Log.trace((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Waiting for configuration to process lifecycle request event", (Object[])new Object[0]);
            return;
        }
        Map eventData = event.getEventData();
        if (eventData == null) {
            Log.trace((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Failed to process lifecycle event '%s for event data'", (Object[])new Object[]{"Unexpected Null Value"});
            return;
        }
        String lifecycleAction = DataReader.optString((Map)eventData, (String)"action", (String)"");
        if ("start".equals(lifecycleAction)) {
            Log.debug((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Starting lifecycle", (Object[])new Object[0]);
            this.startApplicationLifecycle(event, configurationSharedState.getValue());
        } else if ("pause".equals(lifecycleAction)) {
            Log.debug((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Pausing lifecycle", (Object[])new Object[0]);
            this.pauseApplicationLifecycle(event);
        } else {
            Log.warning((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Invalid action for lifecycle request event", (Object[])new Object[0]);
        }
    }

    void updateLastKnownTimestamp(Event event) {
        this.lifecycleV2.updateLastKnownTimestamp(event);
    }

    private void startApplicationLifecycle(Event event, Map<String, Object> configurationSharedState) {
        boolean isInstall = this.isInstall();
        this.lifecycleV1.start(event, configurationSharedState, isInstall);
        this.lifecycleV2.start(event, isInstall);
        if (isInstall) {
            this.persistInstallDate(event);
        }
    }

    private void pauseApplicationLifecycle(Event event) {
        this.lifecycleV1.pause(event);
        this.lifecycleV2.pause(event);
    }

    private boolean isInstall() {
        return this.lifecycleDataStore != null && !this.lifecycleDataStore.contains("InstallDate");
    }

    private void persistInstallDate(Event event) {
        if (this.lifecycleDataStore == null) {
            return;
        }
        long startTimestampInSeconds = event.getTimestampInSeconds();
        this.lifecycleDataStore.setLong("InstallDate", startTimestampInSeconds);
    }
}

