/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.analytics.internal;

import com.adobe.marketing.mobile.Analytics;
import com.adobe.marketing.mobile.MobileCore;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\tJ\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/adobe/marketing/mobile/analytics/internal/AnalyticsVersionProvider;", "", "()V", "FALLBACK_VERSION", "", "OPERATING_SYSTEM", "buildVersionString", "coreExtensionVersion", "analyticsExtensionVersion", "buildVersionString$analytics_phoneRelease", "getFormattedVersion", "versionString", "getVersionString", "mobileCoreVersion", "analyticsVersion", "analytics_phoneRelease"})
@SourceDebugExtension(value={"SMAP\nAnalyticsVersionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyticsVersionProvider.kt\ncom/adobe/marketing/mobile/analytics/internal/AnalyticsVersionProvider\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,83:1\n37#2,2:84\n37#2,2:86\n*S KotlinDebug\n*F\n+ 1 AnalyticsVersionProvider.kt\ncom/adobe/marketing/mobile/analytics/internal/AnalyticsVersionProvider\n*L\n52#1:84,2\n73#1:86,2\n*E\n"})
public final class AnalyticsVersionProvider {
    @NotNull
    public static final AnalyticsVersionProvider INSTANCE = new AnalyticsVersionProvider();
    @NotNull
    private static final String FALLBACK_VERSION = "unknown";
    @NotNull
    private static final String OPERATING_SYSTEM = "AND";

    private AnalyticsVersionProvider() {
    }

    @NotNull
    public final String buildVersionString$analytics_phoneRelease(@NotNull String coreExtensionVersion, @NotNull String analyticsExtensionVersion) {
        Intrinsics.checkNotNullParameter((Object)coreExtensionVersion, (String)"coreExtensionVersion");
        Intrinsics.checkNotNullParameter((Object)analyticsExtensionVersion, (String)"analyticsExtensionVersion");
        String analyticsVersion = this.getVersionString(coreExtensionVersion, analyticsExtensionVersion);
        return !StringUtils.isNullOrEmpty((String)analyticsVersion) ? analyticsVersion : FALLBACK_VERSION;
    }

    public static /* synthetic */ String buildVersionString$analytics_phoneRelease$default(AnalyticsVersionProvider analyticsVersionProvider, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            String string3 = MobileCore.extensionVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"extensionVersion()");
            string = string3;
        }
        if ((n & 2) != 0) {
            String string4 = Analytics.extensionVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"extensionVersion()");
            string2 = string4;
        }
        return analyticsVersionProvider.buildVersionString$analytics_phoneRelease(string, string2);
    }

    private final String getVersionString(String mobileCoreVersion, String analyticsVersion) {
        String coreVersion = mobileCoreVersion;
        String wrapperType = "N";
        String[] stringArray = new String[]{"-"};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)coreVersion, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] mobileCoreVersionInfo = thisCollection$iv.toArray(new String[0]);
        if (mobileCoreVersionInfo.length == 2) {
            coreVersion = mobileCoreVersionInfo[0];
            wrapperType = mobileCoreVersionInfo[1];
        }
        String mobileCoreFormattedVersion = this.getFormattedVersion(coreVersion);
        String analyticsFormattedVersion = this.getFormattedVersion(analyticsVersion);
        return OPERATING_SYSTEM + wrapperType + analyticsFormattedVersion + mobileCoreFormattedVersion;
    }

    private final String getFormattedVersion(String versionString) {
        String formattedVersionString = "000000";
        String[] stringArray = new String[]{"."};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)versionString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] versionInfo = thisCollection$iv.toArray(new String[0]);
        if (versionInfo.length == 3) {
            String major = versionInfo[0].length() == 1 ? '0' + versionInfo[0] : versionInfo[0];
            String minor = versionInfo[1].length() == 1 ? '0' + versionInfo[1] : versionInfo[1];
            String build = versionInfo[2].length() == 1 ? '0' + versionInfo[2] : versionInfo[2];
            formattedVersionString = major + minor + build;
        }
        return formattedVersionString;
    }
}

