/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.analytics.internal;

import com.adobe.marketing.mobile.MobilePrivacyStatus;
import com.adobe.marketing.mobile.analytics.internal.AnalyticsConstants;
import com.adobe.marketing.mobile.analytics.internal.AnalyticsRequestSerializer;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.DataReaderException;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0010\u0018\u0000 S2\u00020\u0001:\u0001SB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010C\u001a\u00020DH\u0002J\u001e\u0010E\u001a\u00020D2\u0014\u0010F\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\tH\u0002J\u001e\u0010G\u001a\u00020D2\u0014\u0010H\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\tH\u0002J\u001e\u0010I\u001a\u00020D2\u0014\u0010J\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\tH\u0002J\u001e\u0010K\u001a\u00020D2\u0014\u0010L\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\tH\u0002J\u001e\u0010M\u001a\u00020D2\u0014\u0010N\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\tH\u0002J\u0006\u0010O\u001a\u00020DJ1\u0010P\u001a\u00020D2\"\u0010Q\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\t0\tH\u0000\u00a2\u0006\u0002\bRR\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\"\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u000e@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000bR\"\u0010\u0017\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0007R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u001e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u001a@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u001e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u001a@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u001a\u0010 \u001a\u00020\u001aX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001b\"\u0004\b\"\u0010#R\u001e\u0010$\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u001a@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001bR\u0011\u0010&\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001bR\u0011\u0010'\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001bR\u001a\u0010(\u001a\u00020)X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001e\u0010.\u001a\u00020)2\u0006\u0010\u0003\u001a\u00020)@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010+R\u001e\u00100\u001a\u00020)2\u0006\u0010\u0003\u001a\u00020)@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010+R\"\u00102\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u0007R\"\u00104\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0007R\"\u00106\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u0007R\u001e\u00109\u001a\u0002082\u0006\u0010\u0003\u001a\u000208@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u001e\u0010<\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u000e@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\u0011R\"\u0010>\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010\u0007R\"\u0010@\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010\u0007R\u000e\u0010B\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/adobe/marketing/mobile/analytics/internal/AnalyticsState;", "", "()V", "<set-?>", "", "advertisingIdentifier", "getAdvertisingIdentifier$analytics_phoneRelease", "()Ljava/lang/String;", "analyticsIdVisitorParameters", "", "getAnalyticsIdVisitorParameters", "()Ljava/util/Map;", "applicationID", "getApplicationID$analytics_phoneRelease", "", "batchLimit", "getBatchLimit$analytics_phoneRelease", "()I", "blob", "getBlob$analytics_phoneRelease", "defaultData", "", "getDefaultData$analytics_phoneRelease", "host", "getHost$analytics_phoneRelease", "isAnalyticsConfigured", "", "()Z", "isAnalyticsForwardingEnabled", "isAnalyticsForwardingEnabled$analytics_phoneRelease", "isAssuranceSessionActive", "isAssuranceSessionActive$analytics_phoneRelease", "isBackdateSessionInfoEnabled", "isBackdateSessionInfoEnabled$analytics_phoneRelease", "setBackdateSessionInfoEnabled$analytics_phoneRelease", "(Z)V", "isOfflineTrackingEnabled", "isOfflineTrackingEnabled$analytics_phoneRelease", "isOptIn", "isVisitorIDServiceEnabled", "lastResetIdentitiesTimestampSec", "", "getLastResetIdentitiesTimestampSec$analytics_phoneRelease", "()J", "setLastResetIdentitiesTimestampSec$analytics_phoneRelease", "(J)V", "lifecycleMaxSessionLength", "getLifecycleMaxSessionLength$analytics_phoneRelease", "lifecycleSessionStartTimestamp", "getLifecycleSessionStartTimestamp$analytics_phoneRelease", "locationHint", "getLocationHint$analytics_phoneRelease", "marketingCloudId", "getMarketingCloudId$analytics_phoneRelease", "marketingCloudOrganizationID", "getMarketingCloudOrganizationID$analytics_phoneRelease", "Lcom/adobe/marketing/mobile/MobilePrivacyStatus;", "privacyStatus", "getPrivacyStatus$analytics_phoneRelease", "()Lcom/adobe/marketing/mobile/MobilePrivacyStatus;", "referrerTimeout", "getReferrerTimeout$analytics_phoneRelease", "rsids", "getRsids$analytics_phoneRelease", "serializedVisitorIDsList", "getSerializedVisitorIDsList$analytics_phoneRelease", "sessionTimeout", "clearPlacesData", "", "extractAssuranceInfo", "assuranceInfo", "extractConfigurationInfo", "configuration", "extractIdentityInfo", "identityInfo", "extractLifecycleInfo", "lifecycleData", "extractPlacesInfo", "placesInfo", "resetIdentities", "update", "dataMap", "update$analytics_phoneRelease", "Companion", "analytics_phoneRelease"})
public final class AnalyticsState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String host;
    private long lastResetIdentitiesTimestampSec;
    private boolean isAnalyticsForwardingEnabled;
    private boolean isOfflineTrackingEnabled;
    private int batchLimit;
    @NotNull
    private MobilePrivacyStatus privacyStatus = AnalyticsConstants.Default.INSTANCE.getDEFAULT_PRIVACY_STATUS();
    private int referrerTimeout;
    private boolean isAssuranceSessionActive;
    private boolean isBackdateSessionInfoEnabled;
    @Nullable
    private String marketingCloudOrganizationID;
    @Nullable
    private String rsids;
    @Nullable
    private String marketingCloudId;
    @Nullable
    private String locationHint;
    @Nullable
    private String advertisingIdentifier;
    @Nullable
    private String blob;
    @Nullable
    private String serializedVisitorIDsList;
    @Nullable
    private String applicationID;
    @NotNull
    private final Map<String, String> defaultData = new HashMap();
    private int sessionTimeout = 300000;
    private long lifecycleMaxSessionLength;
    private long lifecycleSessionStartTimestamp;
    @NotNull
    private static final String LOG_TAG = "AnalyticsState";

    @Nullable
    public final String getHost$analytics_phoneRelease() {
        return this.host;
    }

    public final long getLastResetIdentitiesTimestampSec$analytics_phoneRelease() {
        return this.lastResetIdentitiesTimestampSec;
    }

    public final void setLastResetIdentitiesTimestampSec$analytics_phoneRelease(long l) {
        this.lastResetIdentitiesTimestampSec = l;
    }

    public final boolean isAnalyticsForwardingEnabled$analytics_phoneRelease() {
        return this.isAnalyticsForwardingEnabled;
    }

    public final boolean isOfflineTrackingEnabled$analytics_phoneRelease() {
        return this.isOfflineTrackingEnabled;
    }

    public final int getBatchLimit$analytics_phoneRelease() {
        return this.batchLimit;
    }

    @NotNull
    public final MobilePrivacyStatus getPrivacyStatus$analytics_phoneRelease() {
        return this.privacyStatus;
    }

    public final int getReferrerTimeout$analytics_phoneRelease() {
        return this.referrerTimeout;
    }

    public final boolean isAssuranceSessionActive$analytics_phoneRelease() {
        return this.isAssuranceSessionActive;
    }

    public final boolean isBackdateSessionInfoEnabled$analytics_phoneRelease() {
        return this.isBackdateSessionInfoEnabled;
    }

    public final void setBackdateSessionInfoEnabled$analytics_phoneRelease(boolean bl) {
        this.isBackdateSessionInfoEnabled = bl;
    }

    @Nullable
    public final String getMarketingCloudOrganizationID$analytics_phoneRelease() {
        return this.marketingCloudOrganizationID;
    }

    @Nullable
    public final String getRsids$analytics_phoneRelease() {
        return this.rsids;
    }

    @Nullable
    public final String getMarketingCloudId$analytics_phoneRelease() {
        return this.marketingCloudId;
    }

    @Nullable
    public final String getLocationHint$analytics_phoneRelease() {
        return this.locationHint;
    }

    @Nullable
    public final String getAdvertisingIdentifier$analytics_phoneRelease() {
        return this.advertisingIdentifier;
    }

    @Nullable
    public final String getBlob$analytics_phoneRelease() {
        return this.blob;
    }

    @Nullable
    public final String getSerializedVisitorIDsList$analytics_phoneRelease() {
        return this.serializedVisitorIDsList;
    }

    @Nullable
    public final String getApplicationID$analytics_phoneRelease() {
        return this.applicationID;
    }

    @NotNull
    public final Map<String, String> getDefaultData$analytics_phoneRelease() {
        return this.defaultData;
    }

    public final long getLifecycleMaxSessionLength$analytics_phoneRelease() {
        return this.lifecycleMaxSessionLength;
    }

    public final long getLifecycleSessionStartTimestamp$analytics_phoneRelease() {
        return this.lifecycleSessionStartTimestamp;
    }

    public final void update$analytics_phoneRelease(@NotNull Map<String, ? extends Map<String, ? extends Object>> dataMap) {
        Intrinsics.checkNotNullParameter(dataMap, (String)"dataMap");
        for (Map.Entry<String, ? extends Map<String, ? extends Object>> entry : dataMap.entrySet()) {
            Object[] key = entry.getKey();
            Map<String, ? extends Object> value = entry.getValue();
            if (value == null) {
                Object[] objectArray = new Object[]{key};
                Log.trace((String)"Analytics", (String)LOG_TAG, (String)"update - Unable to extract data for %s, it was null.", (Object[])objectArray);
                continue;
            }
            switch (key) {
                case "com.adobe.module.configuration": {
                    this.extractConfigurationInfo(value);
                    break;
                }
                case "com.adobe.module.lifecycle": {
                    this.extractLifecycleInfo(value);
                    break;
                }
                case "com.adobe.module.identity": {
                    this.extractIdentityInfo(value);
                    break;
                }
                case "com.adobe.module.places": {
                    this.extractPlacesInfo(value);
                    break;
                }
                case "com.adobe.assurance": {
                    this.extractAssuranceInfo(value);
                }
            }
        }
    }

    private final void extractConfigurationInfo(Map<String, ? extends Object> configuration) {
        this.host = DataReader.optString(configuration, (String)"analytics.server", null);
        this.rsids = DataReader.optString(configuration, (String)"analytics.rsids", null);
        this.isAnalyticsForwardingEnabled = DataReader.optBoolean(configuration, (String)"analytics.aamForwardingEnabled", (boolean)false);
        this.isOfflineTrackingEnabled = DataReader.optBoolean(configuration, (String)"analytics.offlineEnabled", (boolean)false);
        this.batchLimit = DataReader.optInt(configuration, (String)"analytics.batchLimit", (int)0);
        int referrerTimeoutFromConfig = DataReader.optInt(configuration, (String)"analytics.launchHitDelay", (int)0);
        if (referrerTimeoutFromConfig >= 0) {
            this.referrerTimeout = referrerTimeoutFromConfig;
        }
        this.marketingCloudOrganizationID = DataReader.optString(configuration, (String)"experienceCloud.org", null);
        this.isBackdateSessionInfoEnabled = DataReader.optBoolean(configuration, (String)"analytics.backdatePreviousSessionInfo", (boolean)false);
        MobilePrivacyStatus mobilePrivacyStatus = MobilePrivacyStatus.fromString((String)DataReader.optString(configuration, (String)"global.privacy", (String)AnalyticsConstants.Default.INSTANCE.getDEFAULT_PRIVACY_STATUS().getValue()));
        Intrinsics.checkNotNullExpressionValue((Object)mobilePrivacyStatus, (String)"fromString(\n            \u2026)\n            )\n        )");
        this.privacyStatus = mobilePrivacyStatus;
        this.sessionTimeout = DataReader.optInt(configuration, (String)"lifecycle.sessionTimeout", (int)300000);
    }

    private final void extractIdentityInfo(Map<String, ? extends Object> identityInfo) {
        this.marketingCloudId = DataReader.optString(identityInfo, (String)"mid", null);
        this.blob = DataReader.optString(identityInfo, (String)"blob", null);
        this.locationHint = DataReader.optString(identityInfo, (String)"locationhint", null);
        this.advertisingIdentifier = DataReader.optString(identityInfo, (String)"advertisingidentifier", null);
        if (identityInfo.containsKey("visitoridslist")) {
            try {
                List visitorIdsList = DataReader.getTypedListOfMap(Object.class, identityInfo, (String)"visitoridslist");
                this.serializedVisitorIDsList = AnalyticsRequestSerializer.Companion.generateAnalyticsCustomerIdString$analytics_phoneRelease(visitorIdsList);
            }
            catch (DataReaderException ex) {
                Object[] objectArray = new Object[]{ex};
                Log.debug((String)"Analytics", (String)LOG_TAG, (String)"extractIdentityInfo - The format of the serializedVisitorIDsList list is invalid: %s", (Object[])objectArray);
            }
        }
    }

    private final void extractPlacesInfo(Map<String, ? extends Object> placesInfo) {
        Object v;
        String regionName;
        String regionId;
        Map map = DataReader.optTypedMap(Object.class, placesInfo, (String)"currentpoi", null);
        if (map == null) {
            return;
        }
        Map placesContextData = map;
        Object v2 = placesContextData.get("regionid");
        String string = regionId = v2 instanceof String ? (String)v2 : null;
        if (!StringUtils.isNullOrEmpty((String)regionId)) {
            String string2 = regionId;
            if (string2 == null) {
                string2 = "";
            }
            this.defaultData.put("a.loc.poi.id", string2);
        }
        String string3 = regionName = (v = placesContextData.get("regionname")) instanceof String ? (String)v : null;
        if (!StringUtils.isNullOrEmpty((String)regionName)) {
            String string4 = regionName;
            if (string4 == null) {
                string4 = "";
            }
            this.defaultData.put("a.loc.poi", string4);
        }
    }

    private final void extractLifecycleInfo(Map<String, ? extends Object> lifecycleData) {
        String appId;
        String runMode;
        String carrier;
        String deviceResolution;
        String deviceName;
        this.lifecycleSessionStartTimestamp = DataReader.optLong(lifecycleData, (String)"starttimestampmillis", (long)0L);
        this.lifecycleMaxSessionLength = DataReader.optLong(lifecycleData, (String)"maxsessionlength", (long)0L);
        Map lifecycleContextData = DataReader.optTypedMap(String.class, lifecycleData, (String)"lifecyclecontextdata", null);
        if (lifecycleContextData == null || lifecycleContextData.isEmpty()) {
            return;
        }
        String osVersion = (String)lifecycleContextData.get("osversion");
        if (!StringUtils.isNullOrEmpty((String)osVersion)) {
            String string = osVersion;
            if (string == null) {
                string = "";
            }
            this.defaultData.put("a.OSVersion", string);
        }
        if (!StringUtils.isNullOrEmpty((String)(deviceName = (String)lifecycleContextData.get("devicename")))) {
            String string = deviceName;
            if (string == null) {
                string = "";
            }
            this.defaultData.put("a.DeviceName", string);
        }
        if (!StringUtils.isNullOrEmpty((String)(deviceResolution = (String)lifecycleContextData.get("resolution")))) {
            String string = deviceResolution;
            if (string == null) {
                string = "";
            }
            this.defaultData.put("a.Resolution", string);
        }
        if (!StringUtils.isNullOrEmpty((String)(carrier = (String)lifecycleContextData.get("carriername")))) {
            String string = carrier;
            if (string == null) {
                string = "";
            }
            this.defaultData.put("a.CarrierName", string);
        }
        if (!StringUtils.isNullOrEmpty((String)(runMode = (String)lifecycleContextData.get("runmode")))) {
            String string = runMode;
            if (string == null) {
                string = "";
            }
            this.defaultData.put("a.RunMode", string);
        }
        if (!StringUtils.isNullOrEmpty((String)(appId = (String)lifecycleContextData.get("appid")))) {
            String string = appId;
            if (string == null) {
                string = "";
            }
            this.defaultData.put("a.AppID", string);
            this.applicationID = appId;
        }
    }

    private final void extractAssuranceInfo(Map<String, ? extends Object> assuranceInfo) {
        String assuranceSessionId = DataReader.optString(assuranceInfo, (String)"sessionid", null);
        this.isAssuranceSessionActive = !StringUtils.isNullOrEmpty((String)assuranceSessionId);
    }

    @NotNull
    public final Map<String, String> getAnalyticsIdVisitorParameters() {
        Map analyticsIdVisitorParameters = new HashMap();
        if (StringUtils.isNullOrEmpty((String)this.marketingCloudId)) {
            return analyticsIdVisitorParameters;
        }
        Map map = analyticsIdVisitorParameters;
        String string = "mid";
        String string2 = this.marketingCloudId;
        if (string2 == null) {
            string2 = "";
        }
        String string3 = string2;
        map.put(string, string3);
        if (!StringUtils.isNullOrEmpty((String)this.blob)) {
            map = analyticsIdVisitorParameters;
            string = "aamb";
            String string4 = this.blob;
            if (string4 == null) {
                string4 = "";
            }
            string3 = string4;
            map.put(string, string3);
        }
        if (!StringUtils.isNullOrEmpty((String)this.locationHint)) {
            map = analyticsIdVisitorParameters;
            string = "aamlh";
            String string5 = this.locationHint;
            if (string5 == null) {
                string5 = "";
            }
            string3 = string5;
            map.put(string, string3);
        }
        return analyticsIdVisitorParameters;
    }

    public final boolean isAnalyticsConfigured() {
        return !StringUtils.isNullOrEmpty((String)this.rsids) && !StringUtils.isNullOrEmpty((String)this.host);
    }

    public final boolean isVisitorIDServiceEnabled() {
        return !StringUtils.isNullOrEmpty((String)this.marketingCloudOrganizationID);
    }

    public final void resetIdentities() {
        this.clearPlacesData();
        this.marketingCloudId = null;
        this.locationHint = null;
        this.blob = null;
        this.serializedVisitorIDsList = null;
        this.applicationID = null;
        this.advertisingIdentifier = null;
    }

    private final void clearPlacesData() {
        this.defaultData.remove("a.loc.poi.id");
        this.defaultData.remove("a.loc.poi");
    }

    public final boolean isOptIn() {
        return this.privacyStatus == MobilePrivacyStatus.OPT_IN;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adobe/marketing/mobile/analytics/internal/AnalyticsState$Companion;", "", "()V", "LOG_TAG", "", "analytics_phoneRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

