/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.auth.impl.cug;

import com.day.cq.auth.impl.CugSupport;
import com.day.cq.auth.impl.cug.CugRoot;
import com.day.cq.auth.impl.cug.CugSupportWebConsolePlugin;
import java.security.Principal;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(label="%auth.cug.name", description="%auth.cug.description", metatype=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(name="service.description", value={"Day CQ Closed User Group (CUG) Support"}), @Property(name="event.topics", value={"org/apache/sling/api/resource/ResourceResolverMapping/CHANGED"}, propertyPrivate=true)})
public class CugSupportImpl
implements CugSupport,
EventListener,
EventHandler {
    private static final String CUG_ENABLED = "cug.enabled";
    private static final boolean CUG_ENABLED_DEFAULT = false;
    private static final String CUG_EXEMPTED = "cug.exempted.principals";
    private static final String CUG_EXEMPTED_DEFAULT = "administrators";
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Property(name="cug.exempted.principals", value={"administrators"}, cardinality=200)
    private String[] cugExemptedPrincipals;
    @Property(name="cug.enabled", boolValue={false})
    private boolean cugEnabled;
    private static final String CUG_PRINCIPALS_REGEX = "cug.principals.regex";
    private static final String CUG_PRINCIPALS_REPLACEMENT = "cug.principals.replacement";
    @Property(name="cug.principals.regex", value={""})
    private String cugPrincipalsRegex;
    @Property(name="cug.principals.replacement", value={""})
    private String cugPrincipalsReplacement;
    private final Logger log = LoggerFactory.getLogger(CugSupportImpl.class);
    private ResourceResolver resolver;
    private Map<String, Object> properties;
    private ServiceRegistration registration;
    private final Map<String, CugRoot> cugRoots = new TreeMap(Collections.reverseOrder());
    private CugSupportWebConsolePlugin webConsolePlugin;

    @Activate
    private void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this.properties = properties;
        this.cugRoots.clear();
        try {
            this.resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            this.configure(bundleContext, properties);
            this.registerObservation();
        }
        catch (LoginException le) {
            this.log.error("activate: Cannot get an administrative ResourceResolver; CUG support disabled", (Throwable)le);
        }
        try {
            this.webConsolePlugin = new CugSupportWebConsolePlugin(bundleContext, this);
        }
        catch (Throwable t) {
            this.log.warn("activate: Failed registering the CUG Web Console Plugin", t);
        }
    }

    @Modified
    private void configure(BundleContext bundleContext, Map<String, Object> properties) {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        if (properties != null) {
            this.properties = properties;
        }
        this.cugExemptedPrincipals = OsgiUtil.toStringArray(properties.get(CUG_EXEMPTED));
        if (this.cugExemptedPrincipals == null) {
            this.cugExemptedPrincipals = new String[]{CUG_EXEMPTED_DEFAULT};
        }
        this.cugEnabled = OsgiUtil.toBoolean(properties.get(CUG_ENABLED), false);
        if (this.cugEnabled) {
            this.findInitialSet();
            this.registration = bundleContext.registerService(new String[]{"com.day.cq.auth.impl.CugSupport", EventHandler.class.getName()}, (Object)this, this.getProperties());
        }
        this.cugPrincipalsRegex = OsgiUtil.toString(properties.get(CUG_PRINCIPALS_REGEX), "");
        this.cugPrincipalsReplacement = OsgiUtil.toString(properties.get(CUG_PRINCIPALS_REPLACEMENT), "");
    }

    private void registerObservation() {
        Session session = this.getSession();
        if (session != null) {
            try {
                session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 63, "/", true, null, null, true);
                this.log.info("registered observation listener");
            }
            catch (RepositoryException e) {
                this.log.error("error while registering observation: ", (Throwable)e);
            }
        }
    }

    private void unregisterObservation() {
        Session session = this.getSession();
        if (session != null) {
            try {
                session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
                this.log.info("unregistered ovservation.");
            }
            catch (RepositoryException e) {
                this.log.error("error unregistering observation: ", (Throwable)e);
            }
        }
    }

    private Session getSession() {
        return (Session)this.resolver.adaptTo(Session.class);
    }

    @Deactivate
    private void deactivate() {
        if (this.webConsolePlugin != null) {
            this.webConsolePlugin.dispose();
            this.webConsolePlugin = null;
        }
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        this.unregisterObservation();
        if (this.resolver != null) {
            this.resolver.close();
            this.resolver = null;
        }
        this.cugRoots.clear();
    }

    public void onEvent(EventIterator events) {
        HashSet<String> cugRootCandidates = new HashSet<String>();
        while (events.hasNext()) {
            Event event = events.nextEvent();
            try {
                String parent;
                String path = event.getPath();
                if (this.cugRoots.containsKey(path)) {
                    cugRootCandidates.add(path);
                    continue;
                }
                String name = ResourceUtil.getName((String)path);
                if (name.startsWith("cq:cug")) {
                    parent = ResourceUtil.getParent((String)path);
                    parent = ResourceUtil.getParent((String)parent);
                    cugRootCandidates.add(parent);
                    continue;
                }
                if (!"jcr:content".equals(name) || !this.cugRoots.containsKey(parent = ResourceUtil.getParent((String)path))) continue;
                cugRootCandidates.add(parent);
            }
            catch (RepositoryException e) {
                this.log.error("error accessing event: ", (Throwable)e);
            }
        }
        if (this.manage(cugRootCandidates)) {
            this.updateRegistration();
        }
    }

    public void handleEvent(org.osgi.service.event.Event event) {
        this.updateRegistration();
    }

    @Override
    public String getLoginPage(HttpServletRequest request) {
        CugRoot cugRoot = this.getCugRoot(request);
        if (cugRoot != null) {
            String loginPage = cugRoot.getLoginPath();
            this.log.debug("Found login page {} of cug root {}", (Object)loginPage, (Object)cugRoot.getRoot());
            if (loginPage != null) {
                if (ResourceUtil.isNonExistingResource((Resource)this.resolver.resolve(loginPage))) {
                    this.log.info("getLoginPage: Configured login page {} does not exist, using default", (Object)loginPage);
                }
                return loginPage;
            }
            this.log.debug("getLoginPage: CUG Root {} defines no login page, using default", (Object)cugRoot);
        }
        return null;
    }

    @Override
    public String getRealm(HttpServletRequest request) {
        CugRoot cugRoot = this.getCugRoot(request);
        return cugRoot != null ? cugRoot.getRealm() : null;
    }

    private CugRoot getCugRoot(HttpServletRequest request) {
        if (this.cugEnabled) {
            Resource mappedResource;
            String handlerPath = null;
            if (request.getParameter("resource") != null) {
                handlerPath = request.getParameter("resource");
            }
            if (handlerPath == null) {
                handlerPath = request.getPathInfo();
            }
            if (handlerPath == null) {
                handlerPath = "/";
            }
            if (!ResourceUtil.isNonExistingResource((Resource)(mappedResource = this.resolver.resolve(request, handlerPath)))) {
                handlerPath = mappedResource.getPath();
            }
            this.log.debug("Trying to find cug root for {}", (Object)handlerPath);
            for (Map.Entry<String, CugRoot> rootMapEntry : this.cugRoots.entrySet()) {
                if (!handlerPath.startsWith(rootMapEntry.getKey())) continue;
                return rootMapEntry.getValue();
            }
        }
        return null;
    }

    boolean isEnabled() {
        return this.cugEnabled;
    }

    String[] getExemptedPrincipals() {
        return this.cugExemptedPrincipals;
    }

    CugRoot[] getCugRoots() {
        return this.cugRoots.values().toArray(new CugRoot[this.cugRoots.values().size()]);
    }

    private Dictionary<String, Object> getProperties() {
        Hashtable<String, Object> newProps = new Hashtable<String, Object>();
        for (String key : this.properties.keySet()) {
            newProps.put(key, this.properties.get(key));
        }
        HashSet<String> authReqs = new HashSet<String>();
        for (CugRoot cugRoot : this.cugRoots.values()) {
            authReqs.add(cugRoot.getRegistrationPath());
            authReqs.add(cugRoot.getRoot());
            if (cugRoot.getLoginPath() == null) continue;
            authReqs.add("-" + this.toRawPath(cugRoot.getLoginPath()));
        }
        newProps.put("sling.auth.requirements", authReqs.toArray(new String[authReqs.size()]));
        return newProps;
    }

    private String toRawPath(String path) {
        Resource loginPageResource;
        if (this.resolver != null && !ResourceUtil.isNonExistingResource((Resource)(loginPageResource = this.resolver.resolve(path)))) {
            return this.resolver.map(loginPageResource.getPath());
        }
        return path;
    }

    private void updateRegistration() {
        try {
            this.registration.setProperties(this.getProperties());
        }
        catch (NullPointerException npe) {
        }
        catch (IllegalStateException ise) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void findInitialSet() {
        String queryString = "select * from nt:base where cq:cugEnabled='true'";
        try {
            Session session = (Session)this.resolver.adaptTo(Session.class);
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query q = qm.createQuery(queryString, "sql");
            NodeIterator nodes = q.execute().getNodes();
            while (nodes.hasNext()) {
                Node node = nodes.nextNode();
                if ("jcr:content".equals(node.getName())) {
                    node = node.getParent();
                }
                this.enable(node.getPath(), node);
            }
        }
        catch (RepositoryException re) {
            this.log.error("findInitialSet: Failed finding initial set of CUG roots", (Throwable)re);
        }
    }

    private boolean manage(Set<String> cugRoots) {
        Session session = this.getSession();
        boolean modified = false;
        for (String cugRoot : cugRoots) {
            try {
                if (session.itemExists(cugRoot)) {
                    Node node = (Node)session.getItem(cugRoot);
                    if (CugRoot.isEnabled(node)) {
                        modified |= this.enable(cugRoot, node);
                        continue;
                    }
                    modified |= this.disable(cugRoot);
                    continue;
                }
                modified |= this.disable(cugRoot);
            }
            catch (RepositoryException re) {
                this.log.error("onEvent: Cannot handle potential CUG Root " + cugRoot, (Throwable)re);
            }
        }
        return modified;
    }

    private boolean enable(String cugRoot, Node cugRootNode) throws RepositoryException {
        if (cugRootNode.getPath().startsWith("/jcr:system/")) {
            return false;
        }
        String fullPath = this.resolver.map(cugRoot);
        CugRoot cr = new CugRoot(fullPath, cugRootNode);
        this.cugRoots.put(cugRoot, cr);
        this.syncACLs(cr, true);
        return true;
    }

    private boolean disable(String cugRoot) {
        CugRoot cr = this.cugRoots.remove(cugRoot);
        if (cr != null) {
            this.syncACLs(cr, false);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncACLs(CugRoot cugRoot, boolean applyCugPrincipals) {
        Session session = this.getSession();
        if (session instanceof JackrabbitSession) {
            boolean success = false;
            try {
                if (applyCugPrincipals) {
                    success = this.installCUG(cugRoot);
                }
                success = this.clearCUG(cugRoot);
            }
            catch (Exception ex) {
                this.log.warn("syncACLs: Cannot apply ACL to " + cugRoot.getRoot(), (Throwable)ex);
            }
            finally {
                if (!success) {
                    try {
                        session.refresh(false);
                    }
                    catch (RepositoryException e) {
                        this.log.error("Failed to revert pending changes.", (Throwable)e);
                        throw new SlingException(e.getMessage(), (Throwable)e);
                    }
                }
            }
        } else {
            this.log.warn("syncACLs: Cannot apply ACLs to {}: This is only supported with Jackrabbit based Repositories", (Object)cugRoot.getRoot());
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean installCUG(CugRoot cugRoot) throws RepositoryException {
        this.log.debug("syncACLs: Limitting read access on {}", (Object)cugRoot.getRoot());
        Session session = this.getSession();
        AccessControlManager acMgr = session.getAccessControlManager();
        PrincipalManager principalManager = ((JackrabbitSession)session).getPrincipalManager();
        if (session.itemExists(cugRoot.getRoot())) {
            JackrabbitAccessControlList acl = this.getAcl(cugRoot.getRoot(), acMgr);
            if (acl != null) {
                AccessControlPolicy[] pols;
                if (!acl.isEmpty()) {
                    this.log.debug("Removing existing ACEs at " + cugRoot.getRoot());
                    for (AccessControlEntry ace : acl.getAccessControlEntries()) {
                        acl.removeAccessControlEntry(ace);
                    }
                }
                acl.addEntry(principalManager.getEveryone(), new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}all")}, false);
                for (AccessControlPolicy accessControlPolicy : pols = acMgr.getEffectivePolicies(cugRoot.getRoot())) {
                    if (!(accessControlPolicy instanceof JackrabbitAccessControlList)) continue;
                    JackrabbitAccessControlList effAcl = (JackrabbitAccessControlList)accessControlPolicy;
                    if (cugRoot.getRoot().equals(effAcl.getPath())) continue;
                    AccessControlEntry[] aces = effAcl.getAccessControlEntries();
                    for (String principal : this.cugExemptedPrincipals) {
                        for (AccessControlEntry ace : aces) {
                            if (!principal.equals(ace.getPrincipal().getName())) continue;
                            if (principalManager.hasPrincipal(principal)) {
                                boolean isAllow = ace instanceof JackrabbitAccessControlEntry ? ((JackrabbitAccessControlEntry)ace).isAllow() : true;
                                acl.addEntry(ace.getPrincipal(), ace.getPrivileges(), isAllow);
                                continue;
                            }
                            this.log.warn("Cannot install ACE for cugExempted principal '" + principal + "': Unknown to the PrincipalManager.");
                        }
                    }
                }
                for (String string : cugRoot.getPrincipals()) {
                    void var10_17;
                    Principal princ;
                    if (string == null || "".equals(string)) continue;
                    if (this.cugPrincipalsRegex != null && this.cugPrincipalsRegex.length() > 0) {
                        String newPrincipalName = string.replaceAll(this.cugPrincipalsRegex, this.cugPrincipalsReplacement);
                        this.log.info("replacing principal name " + string + " with " + newPrincipalName);
                        String string2 = newPrincipalName;
                    }
                    if ((princ = principalManager.getPrincipal((String)var10_17)) != null) {
                        acl.addAccessControlEntry(princ, new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}read")});
                        continue;
                    }
                    this.log.warn("Cannot install ACE for admitted principal '" + (String)var10_17 + "': Unknown to the PrincipalManager.");
                }
                acMgr.setPolicy(cugRoot.getRoot(), (AccessControlPolicy)acl);
                session.save();
                return true;
            }
            this.log.warn("Cannot install CUG: No editable AccessControlList at " + cugRoot.getRoot());
        } else {
            this.log.warn("Cannot install CUG: Target node " + cugRoot.getRoot() + " does not exist.");
        }
        return false;
    }

    private boolean clearCUG(CugRoot cugRoot) throws RepositoryException {
        this.log.debug("syncACLs: Removing all access control from {}", (Object)cugRoot.getRoot());
        boolean changed = false;
        Session session = this.getSession();
        AccessControlManager aMgr = session.getAccessControlManager();
        String cugPath = cugRoot.getRoot();
        for (AccessControlPolicy pol : aMgr.getPolicies(cugPath)) {
            if (!(pol instanceof AccessControlList)) continue;
            aMgr.removePolicy(cugPath, pol);
            changed = true;
        }
        if (changed) {
            session.save();
            return true;
        }
        return false;
    }

    private JackrabbitAccessControlList getAcl(String path, AccessControlManager acManager) throws RepositoryException {
        AccessControlPolicyIterator app = acManager.getApplicablePolicies(path);
        while (app.hasNext()) {
            AccessControlPolicy pol = app.nextAccessControlPolicy();
            if (!(pol instanceof JackrabbitAccessControlPolicy)) continue;
            this.log.debug("No Policy present create a new ACL Policy");
            return (JackrabbitAccessControlList)pol;
        }
        for (AccessControlPolicy pol : acManager.getPolicies(path)) {
            if (!(pol instanceof JackrabbitAccessControlPolicy)) continue;
            this.log.debug("Found existing ACL Policy");
            return (JackrabbitAccessControlList)pol;
        }
        return null;
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

