/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.auth.impl;

import com.day.cq.auth.impl.CugSupport;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.auth.core.AuthUtil;
import org.apache.sling.auth.core.spi.AuthenticationHandler;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(label="%auth.loginselector.name", description="%auth.loginselector.description", name="com.day.cq.auth.impl.LoginSelectorHandler", metatype=true)
@Properties(value={@Property(name="path", value={"/"}), @Property(name="service.ranking", intValue={5000}, propertyPrivate=false), @Property(name="auth.loginselector.mappings", label="%auth.loginselector.mappings.name", description="%auth.loginselector.mappings.description", cardinality=100), @Property(name="auth.loginselector.defaultloginpage", label="%auth.loginselector.defaultloginpage.name", description="%auth.loginselector.defaultloginpage.description", value={"/libs/cq/core/content/login"})})
public class LoginSelectorHandler
implements AuthenticationHandler {
    @Property(name="service.description")
    private static final String DESCRIPTION = "Day CQ Login Selector Authentication Handler";
    static final String PROPERTY_MAPPINGS_NAME = "auth.loginselector.mappings";
    static final String PROPERTY_DEFAULT_LOGIN_PAGE_NAME = "auth.loginselector.defaultloginpage";
    private static final String PAR_LOOP_PROTECT = "$$login$$";
    private static final String[] DEFAULT_HANDLE_REGEXP = new String[]{"html", "htm"};
    @Property(cardinality=2000, value={"html", "htm"})
    private static final String PROPERTY_HANDLE_REGEXP = "auth.loginselector.handle";
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private CugSupport cugSupport;
    private final Logger log = LoggerFactory.getLogger(LoginSelectorHandler.class);
    private ResourceResolver resolver;
    private String[] handleExtensions;
    private List<Mapping> loginMappings;
    private String defaultLoginPath;
    private BundleContext bundleContext;
    private Map<String, Object> properties;
    private ServiceRegistration registration;

    public AuthenticationInfo extractCredentials(HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    public boolean requestCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.isRequestIgnored(request)) {
            this.log.debug("requestCredentials: Not requesting credentials for this request");
            return false;
        }
        if (this.isRequestForbidden(request)) {
            this.log.debug("requestCredentials: Access forbidden");
            request.setAttribute("j_reason", (Object)"Authentication Failed");
            AuthUtil.sendInvalid((HttpServletRequest)request, (HttpServletResponse)response);
            return true;
        }
        if (request.getParameter(PAR_LOOP_PROTECT) != null) {
            this.log.error("requestCredentials: Abort login due to apparent misconfiguration.");
            this.log.error("requestCredentials: Possible reasons: login page not existing or not accessible");
            request.setAttribute("j_reason", (Object)"Authentication Failed");
            AuthUtil.sendInvalid((HttpServletRequest)request, (HttpServletResponse)response);
            return true;
        }
        String loginPath = this.getCugRootLoginPage(request);
        if (loginPath == null) {
            loginPath = this.getMappingLoginPage(request);
            if (loginPath == null && this.defaultLoginPath != null && this.resolve(this.defaultLoginPath) != null) {
                loginPath = this.defaultLoginPath;
                this.log.debug("requestCredentials: using default login page [{}] for request [{}].", (Object)loginPath, (Object)request.getRequestURI());
            }
            if (loginPath == null) {
                loginPath = "/system/sling/cqform/defaultlogin";
            }
        }
        if (StringUtils.isNotBlank((String)loginPath)) {
            loginPath = this.rewrite(request, loginPath);
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            params.put("resource", AuthUtil.getLoginResource((HttpServletRequest)request, null));
            params.put(PAR_LOOP_PROTECT, PAR_LOOP_PROTECT);
            if (request.getAttribute("j_reason") != null) {
                Object jReason = request.getAttribute("j_reason");
                String reason = jReason instanceof Enum ? ((Enum)jReason).name() : jReason.toString();
                params.put("j_reason", reason);
            }
            try {
                this.log.debug("redirected user to [{}] for request [{}].", (Object)loginPath, (Object)request.getRequestURI());
                AuthUtil.sendRedirect((HttpServletRequest)request, (HttpServletResponse)new IESaveRedirectSupportResponse(request, response), (String)loginPath, params);
            }
            catch (IOException e) {
                this.log.error("Failed to redirect to the login form " + loginPath, (Throwable)e);
            }
            return true;
        }
        this.log.debug("no login mapping or default login page defined, not redirecting.");
        return false;
    }

    private String rewrite(HttpServletRequest request, String path) {
        String target = StringUtils.endsWith((String)path, (String)".html") ? path : path.concat(".html");
        return this.resolver.map(request, target);
    }

    public void dropCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    @Activate
    private void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this.bundleContext = bundleContext;
        try {
            this.resolver = this.resourceResolverFactory.getResourceResolver(null);
            this.configure(bundleContext, properties);
        }
        catch (LoginException e) {
            this.log.error("error accessing resolver: ", (Throwable)e);
        }
    }

    @Modified
    private void configure(BundleContext context, Map<String, Object> config) {
        String[] entries;
        HashMap<String, Object> properties = config != null ? config : new HashMap<String, Object>();
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        for (String entry : entries = OsgiUtil.toStringArray(properties.get(PROPERTY_MAPPINGS_NAME), new String[0])) {
            Mapping mapping = Mapping.create(entry);
            if (mapping != null) {
                mappings.add(mapping);
                this.log.info("configure: added mapping [{}] from service config.", (Object)mapping);
                continue;
            }
            this.log.warn("configure: invalid mapping [{}] defined in service configuration.", (Object)entry);
        }
        String defaultLoginPath = OsgiUtil.toString(properties.get(PROPERTY_DEFAULT_LOGIN_PAGE_NAME), null);
        this.log.debug("configure: defaultLoginPath={}", (Object)(defaultLoginPath == null ? "-" : defaultLoginPath));
        String[] handleExtensions = LoginSelectorHandler.getValidatedExtensions(OsgiUtil.toStringArray(properties.get(PROPERTY_HANDLE_REGEXP)));
        if (handleExtensions.length == 0) {
            handleExtensions = DEFAULT_HANDLE_REGEXP;
        }
        this.log.debug("configure: auth.loginselector.handle={}", Arrays.asList(handleExtensions));
        if (null != this.registration) {
            this.registration.unregister();
            this.registration = null;
        }
        this.properties = properties;
        this.handleExtensions = handleExtensions;
        this.loginMappings = mappings;
        this.defaultLoginPath = defaultLoginPath;
        this.registration = this.bundleContext.registerService(AuthenticationHandler.class.getName(), (Object)this, this.getProperties());
    }

    private static String[] getValidatedExtensions(String[] handleExtensions) {
        Object[] extensions = new String[]{};
        if (null != handleExtensions) {
            for (String ext : handleExtensions) {
                if (ext == null) continue;
                extensions = (String[])ArrayUtils.add((Object[])extensions, (Object)ext);
            }
        }
        return extensions;
    }

    @Deactivate
    private void deactivate(BundleContext bundleContext) {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        if (this.resolver != null) {
            this.resolver.close();
            this.resolver = null;
        }
    }

    private boolean isRequestIgnored(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (userAgent == null || !userAgent.contains("Mozilla") && !userAgent.contains("Opera")) {
            this.log.debug("ignoreRequest: Ignoring non-browser request from User-Agent {}", (Object)(userAgent == null ? "unknown" : userAgent));
            return true;
        }
        return false;
    }

    private boolean isRequestForbidden(HttpServletRequest request) {
        String[] handleExtensions;
        String ext;
        String pathInfo = request.getPathInfo();
        String method = request.getMethod();
        if (!("GET".equals(method) || "HEAD".equals(method) || "POST".equals(method) && pathInfo != null && pathInfo.endsWith("/j_security_check"))) {
            this.log.debug("ignoreRequest: Ignoring non-GET request {} {}", (Object)method, (Object)(pathInfo == null ? "" : pathInfo));
            return true;
        }
        if (request.getHeader("Referer") == null) {
            this.log.debug("ignoreRequest: Handle request {} without referer", (Object)request.getRequestURI());
            return false;
        }
        if (pathInfo == null || pathInfo.length() == 0 || pathInfo.endsWith("/")) {
            this.log.debug("ignoreRequest: Handle request {} without extension", (Object)(pathInfo == null ? "" : pathInfo));
            return false;
        }
        int lastSlash = pathInfo.lastIndexOf(47);
        String lastPart = pathInfo.substring(lastSlash + 1);
        int lastDot = lastPart.lastIndexOf(46);
        String string = ext = lastDot < 0 ? "" : lastPart.substring(lastDot + 1);
        if (ext.length() == 0) {
            this.log.debug("ignoreRequest: Handle request {} without extension", (Object)pathInfo);
            return false;
        }
        for (String handleExtension : handleExtensions = this.handleExtensions) {
            if (!ext.equals(handleExtension)) continue;
            this.log.debug("ignoreRequest: Extension {} of request {} is being handled", (Object)ext, (Object)pathInfo);
            return false;
        }
        this.log.debug("ignoreRequest: Extension {} of request {} is not handled", (Object)ext, (Object)pathInfo);
        return true;
    }

    private String getCugRootLoginPage(HttpServletRequest request) {
        CugSupport cugSupport = this.cugSupport;
        if (cugSupport != null) {
            return cugSupport.getLoginPage(request);
        }
        return null;
    }

    private String getMappingLoginPage(final HttpServletRequest request) {
        Mapping mapping = (Mapping)CollectionUtils.find(this.loginMappings, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                Mapping m = (Mapping)object;
                return m.handles(request.getRequestURI());
            }
        });
        if (mapping != null) {
            this.log.debug("found mapping [{}] for request [{}].", (Object)mapping, (Object)request.getRequestURI());
            String path = mapping.getLoginPath();
            if (this.resolve(path) != null) {
                return path;
            }
        }
        return null;
    }

    private Dictionary<String, Object> getProperties() {
        Hashtable<String, Object> newProps = new Hashtable<String, Object>();
        for (String key : this.properties.keySet()) {
            newProps.put(key, this.properties.get(key));
        }
        HashSet<String> authReqs = new HashSet<String>();
        if (StringUtils.isNotBlank((String)this.defaultLoginPath)) {
            authReqs.add("-" + this.toRawPath(this.defaultLoginPath));
        }
        for (Mapping m : this.loginMappings) {
            authReqs.add("-" + this.toRawPath(m.getLoginPath()));
        }
        newProps.put("sling.auth.requirements", authReqs.toArray(new String[authReqs.size()]));
        return newProps;
    }

    private String toRawPath(String path) {
        Resource loginPageResource;
        if (this.resolver != null && (loginPageResource = this.resolve(path)) != null) {
            return this.resolver.map(loginPageResource.getPath());
        }
        return path;
    }

    private Resource resolve(String path) {
        Resource loginPageResource = this.resolver.resolve(path);
        if (!ResourceUtil.isNonExistingResource((Resource)loginPageResource)) {
            return loginPageResource;
        }
        return null;
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindCugSupport(CugSupport cugSupport) {
        this.cugSupport = cugSupport;
    }

    protected void unbindCugSupport(CugSupport cugSupport) {
        if (this.cugSupport == cugSupport) {
            this.cugSupport = null;
        }
    }

    private static class IESaveRedirectSupportResponse
    extends HttpServletResponseWrapper {
        public IESaveRedirectSupportResponse(HttpServletRequest request, HttpServletResponse response) {
            super(response);
        }

        public void sendRedirect(String location) throws IOException {
            this.setStatus(200);
            this.setContentType("text/html");
            this.setCharacterEncoding("UTF-8");
            this.setHeader("Cache-control", "no-cache");
            this.addHeader("Cache-control", "no-store");
            this.setHeader("Dispatcher", "no-cache");
            this.setHeader("Pragma", "no-cache");
            this.setHeader("Expires", "0");
            PrintWriter w = this.getWriter();
            ((Writer)w).write("<html><head><script type=\"text/javascript\">");
            ((Writer)w).write("var u=\"");
            ((Writer)w).write(location);
            ((Writer)w).write("\"; if ( window.location.hash) {");
            ((Writer)w).write("u = u + window.location.hash;");
            ((Writer)w).write("} document.location = u;");
            ((Writer)w).write("</script></head><body>");
            ((Writer)w).write("<!-- QUICKSTART_HOMEPAGE - (string used for readyness detection, do not remove) -->");
            ((Writer)w).write("</body></html>");
            ((Writer)w).flush();
            this.flushBuffer();
        }
    }

    private static final class Mapping {
        private String loginPath;
        private String treePath;

        static Mapping create(String s) {
            String[] segments = StringUtils.split((String)s, (char)':');
            if (segments.length == 2) {
                return new Mapping(segments[0], segments[1]);
            }
            return null;
        }

        private Mapping(String loginPath, String treePath) {
            this.loginPath = loginPath;
            this.treePath = treePath;
        }

        public String getLoginPath() {
            return this.loginPath;
        }

        public String getTreePath() {
            return this.treePath;
        }

        public String toString() {
            return "Mapping{loginPath='" + this.loginPath + '\'' + ", treePath='" + this.treePath + '\'' + '}';
        }

        public boolean handles(String requestURI) {
            return StringUtils.startsWith((String)requestURI, (String)this.getTreePath());
        }
    }
}

