/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.auth.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Dictionary;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.sling.auth.core.spi.AbstractAuthenticationHandler;
import org.apache.sling.commons.auth.spi.AuthenticationHandler;
import org.apache.sling.commons.auth.spi.AuthenticationInfo;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractHTTPAuthHandler
implements AuthenticationHandler {
    private static final String NO_LOGIN_FORM = "auth.http.nologin";
    private static final boolean DEFAULT_NO_LOGIN_FORM = false;
    protected static final String REALM = "auth.http.realm";
    protected static final String DEFAULT_REALM = "Day Communique 5";
    static final String REQUEST_LOGIN_PARAMETER = "sling:authRequestLogin";
    private static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String AUTHENTICATION_SCHEME_BASIC = "Basic";
    private static final String DEFAULT_DEFAULT_LOGIN_PAGE = "/libs/cq/core/content/login.html";
    private static final String PROP_DEFAULT_LOGIN_PAGE = "auth.default.loginpage";
    private static final String PROP_FORM_LOGIN = "auth.cred.form";
    private static final String[] DEFAULT_FORM_LOGIN = new String[]{"Firefox", "Shiretoko", "MSIE 7", "MSIE 6"};
    private static final String PROP_UTF8_CREDENTIALS = "auth.cred.utf8";
    private static final String[] DEFAULT_UTF8_CREDENTIALS = new String[]{"Firefox", "Shiretoko", "Chrome", "Opera", "curl", "Wget"};
    static final String LOGIN_FORCED_FLAG = "cq.authhandler.dologin";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean noLoginForm;
    private String realm;
    private String defaultLoginPage;
    private String[] formSupportingUserAgents;
    private String[] utf8EncodingUserAgents;

    AbstractHTTPAuthHandler() {
    }

    public AuthenticationInfo extractCredentials(HttpServletRequest request, HttpServletResponse response) {
        AuthenticationInfo info = this.extractAuthentication(request);
        if (info != null) {
            return info;
        }
        if (this.forceAuthentication(request, response)) {
            return AuthenticationInfo.DOING_AUTH;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean requestCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String rMessage;
        String resource;
        String lpMessage;
        if (response.isCommitted()) {
            this.log.error("requestAuthentication: Response is committed, cannot request authentication");
            return true;
        }
        response.reset();
        if (request.getParameter(REQUEST_LOGIN_PARAMETER) != null) {
            response.sendError(403);
            response.flushBuffer();
            return true;
        }
        if (!this.doLoginForm(request)) {
            this.log.debug("requestAuthentication: Not authenticating here because login form is disabled and cq.authhandler.dologin request attribute is not set");
            return false;
        }
        if (!this.isLoginFormClient(request)) {
            this.sendUnauthorized(request, response);
            return true;
        }
        String loginPage = this.getLoginPage(request);
        if (loginPage == null) {
            loginPage = this.getDefaultLoginPage();
            lpMessage = "requestAuthentication: Using default login page ({})";
        } else {
            lpMessage = "requestAuthentication: Using login page: {}";
        }
        if (this.isLoginFormLoop(request, loginPage)) {
            this.log.warn("requestAuthentication: Authentication loop detected, sending 401/UNAUTHENICATED to force browser based authentication");
            this.log.warn("requestAuthentication: Authentication loop reason: Wrong login page configuration or credentials not accepted for login");
            this.sendUnauthorized(request, response);
            return true;
        }
        if (request.getContextPath() != null && !loginPage.startsWith(request.getContextPath())) {
            loginPage = request.getContextPath() + loginPage;
        }
        if ((resource = request.getParameter("resource")) == null) {
            resource = request.getRequestURI();
            rMessage = "requestAuthentication: Using current request as post-login target: {}";
        } else if (!AbstractAuthenticationHandler.isRedirectValid((HttpServletRequest)request, (String)resource)) {
            resource = "/";
            rMessage = "requestAuthentication: Post-login target {} is invalid; using '/'";
        } else {
            rMessage = "requestAuthentication: Reusing post-login target from request parameter: {}";
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(lpMessage, (Object)loginPage);
            this.log.debug(rMessage, (Object)resource);
        }
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-control", "no-cache");
        response.addHeader("Cache-control", "no-store");
        response.setHeader("Dispatcher", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "0");
        PrintWriter w = response.getWriter();
        ((Writer)w).write("<html><head><script type=\"text/javascript\">");
        ((Writer)w).write("var u=\"");
        ((Writer)w).write(loginPage);
        ((Writer)w).write("?resource=");
        ((Writer)w).write(resource);
        ((Writer)w).write("\"; if ( window.location.hash) {");
        ((Writer)w).write("u = u + window.location.hash;");
        ((Writer)w).write("} document.location = u;");
        ((Writer)w).write("</script></head><body>");
        ((Writer)w).write("<!-- QUICKSTART_HOMEPAGE - (string used for readyness detection, do not remove) -->");
        ((Writer)w).write("</body></html>");
        response.flushBuffer();
        return true;
    }

    public void dropCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    protected final String getDefaultLoginPage() {
        return this.defaultLoginPage;
    }

    protected abstract String getLoginPage(HttpServletRequest var1);

    protected abstract String getRealm(HttpServletRequest var1);

    protected void activate(ComponentContext componentContext) {
        this.configure(componentContext.getProperties());
    }

    protected void configure(Dictionary<?, ?> properties) {
        this.noLoginForm = OsgiUtil.toBoolean(properties.get(NO_LOGIN_FORM), false);
        this.realm = OsgiUtil.toString(properties.get(REALM), DEFAULT_REALM);
        this.defaultLoginPage = OsgiUtil.toString(properties.get(PROP_DEFAULT_LOGIN_PAGE), DEFAULT_DEFAULT_LOGIN_PAGE);
        this.formSupportingUserAgents = OsgiUtil.toStringArray(properties.get(PROP_FORM_LOGIN), DEFAULT_FORM_LOGIN);
        this.utf8EncodingUserAgents = OsgiUtil.toStringArray(properties.get(PROP_UTF8_CREDENTIALS), DEFAULT_UTF8_CREDENTIALS);
        this.log.debug("configure: realm='{}', loginPage='{}'", (Object)this.realm, (Object)this.defaultLoginPage);
    }

    protected AuthenticationInfo extractAuthentication(HttpServletRequest request) {
        char[] password;
        String user;
        String decoded;
        String authHeader = request.getHeader(HEADER_AUTHORIZATION);
        if (!(authHeader != null && authHeader.length() != 0 || authHeader != null && authHeader.length() != 0)) {
            return null;
        }
        int blank = (authHeader = authHeader.trim()).indexOf(32);
        if (blank <= 0) {
            return null;
        }
        String authType = authHeader.substring(0, blank);
        String authInfo = authHeader.substring(blank).trim();
        if (!authType.equalsIgnoreCase(AUTHENTICATION_SCHEME_BASIC)) {
            return null;
        }
        try {
            byte[] encoded = authInfo.getBytes("ISO-8859-1");
            byte[] bytes = Base64.decodeBase64((byte[])encoded);
            decoded = new String(bytes, this.getCredentialsEncoding(request));
        }
        catch (UnsupportedEncodingException uee) {
            this.log.error("extractAuthentication: Cannot en/decode authentication info", (Throwable)uee);
            return null;
        }
        int colIdx = decoded.indexOf(58);
        if (colIdx < 0) {
            user = decoded;
            password = new char[]{};
        } else {
            user = decoded.substring(0, colIdx);
            password = decoded.substring(colIdx + 1).toCharArray();
        }
        return new AuthenticationInfo("BASIC", user, password);
    }

    private boolean forceAuthentication(HttpServletRequest request, HttpServletResponse response) {
        boolean authenticationForced = false;
        if (request.getParameter(REQUEST_LOGIN_PARAMETER) != null) {
            if (!response.isCommitted()) {
                authenticationForced = this.sendUnauthorized(request, response);
            } else {
                this.log.error("forceAuthentication: Response is committed, cannot request authentication");
            }
        } else {
            this.log.debug("forceAuthentication: Not forcing authentication because request parameter {} is not set", (Object)REQUEST_LOGIN_PARAMETER);
        }
        return authenticationForced;
    }

    private boolean sendUnauthorized(HttpServletRequest request, HttpServletResponse response) {
        if (response.isCommitted()) {
            this.log.debug("sendUnauthorized: Response committed, cannot send 401/UNAUTHORIZED");
            return false;
        }
        String realm = this.getRealm(request);
        if (realm == null) {
            realm = this.realm;
        }
        response.reset();
        response.setStatus(401);
        response.setHeader(HEADER_WWW_AUTHENTICATE, "Basic realm=\"" + realm + "\"");
        try {
            response.flushBuffer();
            return true;
        }
        catch (IOException ioe) {
            this.log.error("sendUnauthorized: Failed requesting authentication", (Throwable)ioe);
            return false;
        }
    }

    protected boolean doLoginForm(HttpServletRequest request) {
        if (request.getAttribute(LOGIN_FORCED_FLAG) != null) {
            return true;
        }
        return !this.noLoginForm;
    }

    protected boolean isLoginFormClient(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (this.userAgentMatch(userAgent, this.formSupportingUserAgents)) {
            this.log.debug("isLoginFormClient: Client ({}) assumed to support form based authentication", (Object)userAgent);
            return true;
        }
        this.log.debug("isLoginFormClient: Client ({}) assumed to not support form based authentication, sending 401/UNAUTHORIZED", (Object)userAgent);
        return false;
    }

    private boolean isLoginFormLoop(HttpServletRequest request, String loginPage) {
        String loginUri;
        String ctxPath = request.getContextPath();
        String string = loginUri = ctxPath == null || ctxPath.length() == 0 ? loginPage : ctxPath.concat(loginPage);
        if (request.getRequestURI().equals(loginUri)) {
            return true;
        }
        String referer = request.getHeader("Referer");
        if (referer != null) {
            try {
                URI refererUri = new URI(referer);
                return loginUri.equals(refererUri.getPath());
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        return false;
    }

    private String getCredentialsEncoding(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (this.userAgentMatch(userAgent, this.utf8EncodingUserAgents)) {
            this.log.debug("getCredentialsEncoding: User-Agent ({}) indicates UTF-8 encoding browser, using UTF-8", (Object)userAgent);
            return "UTF-8";
        }
        this.log.debug("getCredentialsEncoding: User-Agent ({}) indicates non-UTF-8 encoding browser, using ISO-8859-1", (Object)userAgent);
        return "ISO-8859-1";
    }

    private boolean userAgentMatch(String userAgent, String ... options) {
        if (userAgent != null && options.length > 0) {
            for (String option : options) {
                if (!userAgent.contains(option)) continue;
                return true;
            }
        }
        return false;
    }
}

