/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.pdfops.options.protectpdf;

import com.adobe.pdfservices.operation.pdfops.options.protectpdf.ContentEncryption;
import com.adobe.pdfservices.operation.pdfops.options.protectpdf.EncryptionAlgorithm;
import com.adobe.pdfservices.operation.pdfops.options.protectpdf.Permissions;
import com.adobe.pdfservices.operation.pdfops.options.protectpdf.ProtectPDFOptions;
import java.util.Objects;

public class PasswordProtectOptions
extends ProtectPDFOptions {
    private String userPassword;
    private String ownerPassword;
    private EncryptionAlgorithm encryptionAlgorithm;
    private ContentEncryption contentEncryption;
    private Permissions permissions;

    private PasswordProtectOptions(Builder builder) {
        this.userPassword = builder.userPassword;
        this.ownerPassword = builder.ownerPassword;
        this.encryptionAlgorithm = builder.encryptionAlgorithm;
        this.contentEncryption = builder.contentEncryption;
        this.permissions = builder.permissions;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public String getOwnerPassword() {
        return this.ownerPassword;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public ContentEncryption getContentEncryption() {
        return this.contentEncryption;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public static class Builder {
        private String userPassword;
        private String ownerPassword;
        private EncryptionAlgorithm encryptionAlgorithm;
        private ContentEncryption contentEncryption;
        private Permissions permissions;

        public Builder setUserPassword(String userPassword) {
            Objects.requireNonNull(userPassword, "User password cannot be null");
            this.userPassword = userPassword;
            return this;
        }

        public Builder setOwnerPassword(String ownerPassword) {
            Objects.requireNonNull(ownerPassword, "Owner password cannot be null");
            this.ownerPassword = ownerPassword;
            return this;
        }

        public Builder setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            return this;
        }

        public Builder setContentEncryption(ContentEncryption contentEncryption) {
            Objects.requireNonNull(contentEncryption, "Content encryption cannot be null");
            this.contentEncryption = contentEncryption;
            return this;
        }

        public Builder setPermissions(Permissions permissions) {
            Objects.requireNonNull(permissions, "Permissions cannot be null");
            this.permissions = permissions;
            return this;
        }

        public PasswordProtectOptions build() {
            return new PasswordProtectOptions(this);
        }
    }
}

