/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.pdfops.options.extractpdf;

import com.adobe.pdfservices.operation.pdfops.options.extractpdf.ExtractElementType;
import com.adobe.pdfservices.operation.pdfops.options.extractpdf.ExtractRenditionsElementType;
import com.adobe.pdfservices.operation.pdfops.options.extractpdf.TableStructureType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class ExtractPDFOptions {
    private TableStructureType tableStructureType;
    private boolean addCharInfo;
    private boolean getStylingInfo;
    private List<ExtractRenditionsElementType> elementsToExtractRenditions;
    private List<ExtractElementType> elementsToExtract;

    private ExtractPDFOptions(Builder builder) {
        this.elementsToExtractRenditions = builder.elementsToExtractRenditions;
        this.elementsToExtract = builder.elementsToExtract;
        this.addCharInfo = builder.addCharInfo;
        this.tableStructureType = builder.tableStructureType;
        this.getStylingInfo = builder.getStylingInfo;
    }

    public TableStructureType getTableStructureType() {
        return this.tableStructureType;
    }

    public Boolean getAddCharInfo() {
        return this.addCharInfo;
    }

    public Boolean getStylingInfo() {
        return this.getStylingInfo;
    }

    public List<ExtractRenditionsElementType> getElementsToExtractRenditions() {
        return this.elementsToExtractRenditions;
    }

    public List<ExtractElementType> getElementsToExtract() {
        return this.elementsToExtract;
    }

    public static Builder extractPdfOptionsBuilder() {
        return new Builder();
    }

    public static class Builder {
        private TableStructureType tableStructureType;
        private boolean addCharInfo;
        private boolean getStylingInfo;
        private List<ExtractRenditionsElementType> elementsToExtractRenditions = new ArrayList<ExtractRenditionsElementType>();
        private List<ExtractElementType> elementsToExtract = new ArrayList<ExtractElementType>();

        private Builder() {
        }

        public Builder addElementToExtract(ExtractElementType elementToExtract) {
            if (elementToExtract != null) {
                this.elementsToExtract.add(elementToExtract);
            }
            return this;
        }

        public Builder addElementsToExtract(List<ExtractElementType> elementsToExtract) {
            if (CollectionUtils.isNotEmpty(elementsToExtract)) {
                this.elementsToExtract.addAll(elementsToExtract);
            }
            return this;
        }

        public Builder addElementToExtractRenditions(ExtractRenditionsElementType elementToExtractRenditions) {
            if (elementToExtractRenditions != null) {
                this.elementsToExtractRenditions.add(elementToExtractRenditions);
            }
            return this;
        }

        public Builder addElementsToExtractRenditions(List<ExtractRenditionsElementType> elementsToExtractRenditions) {
            if (CollectionUtils.isNotEmpty(elementsToExtractRenditions)) {
                this.elementsToExtractRenditions.addAll(elementsToExtractRenditions);
            }
            return this;
        }

        public Builder addTableStructureFormat(TableStructureType tableStructureType) {
            this.tableStructureType = tableStructureType;
            return this;
        }

        public Builder addCharInfo(Boolean addCharInfo) {
            this.addCharInfo = addCharInfo;
            return this;
        }

        public Builder addGetStylingInfo(Boolean getStylingInfo) {
            this.getStylingInfo = getStylingInfo;
            return this;
        }

        public ExtractPDFOptions build() {
            return new ExtractPDFOptions(this);
        }
    }
}

