/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.pdfops;

import com.adobe.pdfservices.operation.ExecutionContext;
import com.adobe.pdfservices.operation.Operation;
import com.adobe.pdfservices.operation.exception.ServiceApiException;
import com.adobe.pdfservices.operation.exception.ServiceUsageException;
import com.adobe.pdfservices.operation.internal.ExtensionMediaTypeMapping;
import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.MediaType;
import com.adobe.pdfservices.operation.internal.api.FileDownloadApi;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.CPFContentAnalyzerResponse;
import com.adobe.pdfservices.operation.internal.exception.OperationException;
import com.adobe.pdfservices.operation.internal.service.ExportPDFService;
import com.adobe.pdfservices.operation.internal.util.FileUtil;
import com.adobe.pdfservices.operation.internal.util.PathUtil;
import com.adobe.pdfservices.operation.internal.util.StringUtil;
import com.adobe.pdfservices.operation.internal.util.ValidationUtil;
import com.adobe.pdfservices.operation.io.FileRef;
import com.adobe.pdfservices.operation.pdfops.options.exportpdf.ExportPDFTargetFormat;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportPDFOperation
implements Operation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportPDFOperation.class);
    private static final Set<String> SUPPORTED_SOURCE_MEDIA_TYPE = new HashSet<String>(Arrays.asList(ExtensionMediaTypeMapping.PDF.getMediaType()));
    private final ExportPDFTargetFormat targetFormat;
    private boolean isInvoked = false;
    private FileRefImpl sourceFileRef;

    private ExportPDFOperation(ExportPDFTargetFormat exportPDFTargetFormat) {
        this.targetFormat = exportPDFTargetFormat;
    }

    public static ExportPDFOperation createNew(ExportPDFTargetFormat exportPDFTargetFormat) {
        Objects.requireNonNull(exportPDFTargetFormat, "Export target format must not be null");
        return new ExportPDFOperation(exportPDFTargetFormat);
    }

    public void setInput(FileRef sourceFileRef) {
        Objects.requireNonNull(sourceFileRef, "No input was set for operation");
        this.sourceFileRef = (FileRefImpl)sourceFileRef;
    }

    @Override
    public FileRef execute(ExecutionContext context) throws ServiceApiException, IOException, ServiceUsageException {
        this.validateInvocationCount();
        InternalExecutionContext internalExecutionContext = (InternalExecutionContext)context;
        this.validate(internalExecutionContext);
        try {
            LOGGER.info("All validations successfully done. Beginning Export Operation execution");
            long startTimeMs = System.currentTimeMillis();
            String location = ExportPDFService.exportPDF(internalExecutionContext, this.sourceFileRef, this.targetFormat, this.getClass().getSimpleName());
            String targetFormatExtension = this.getTargetFormat();
            String targetFileName = FileUtil.getRandomFileName(targetFormatExtension);
            String temporaryDestinationPath = PathUtil.getTemporaryDestinationPath(targetFileName, targetFormatExtension);
            FileDownloadApi.downloadAndSave(internalExecutionContext, location, temporaryDestinationPath, CPFContentAnalyzerResponse.class);
            LOGGER.info("Operation successfully completed. Stored exported PDF at {}", (Object)temporaryDestinationPath);
            LOGGER.debug("Operation Success Info - Request ID: {}, Latency(ms): {}", (Object)StringUtil.getRequestIdFromLocation(location), (Object)(System.currentTimeMillis() - startTimeMs));
            this.isInvoked = true;
            return FileRef.createFromLocalFile(temporaryDestinationPath);
        }
        catch (OperationException oe) {
            throw new ServiceApiException(oe.getErrorMessage(), oe.getRequestTrackingId(), oe.getStatusCode(), oe.getReportErrorCode());
        }
    }

    private String getTargetFormat() {
        switch (this.targetFormat) {
            case PNG: 
            case JPEG: {
                return ExtensionMediaTypeMapping.ZIP.getExtension();
            }
        }
        return this.targetFormat.getFileExt();
    }

    private void validateInvocationCount() {
        if (this.isInvoked) {
            LOGGER.error("Operation instance must only be invoked once");
            throw new IllegalStateException("Operation instance must not be reused, can only be invoked once");
        }
    }

    private void validate(InternalExecutionContext context) {
        if (this.sourceFileRef == null) {
            throw new IllegalArgumentException("No input was set for operation");
        }
        if (this.sourceFileRef.getSourceURL() != null) {
            throw new IllegalArgumentException("Input for the Export PDF Operation can not be sourced from a URL");
        }
        ValidationUtil.validateExecutionContext(context);
        ValidationUtil.validateMediaType(SUPPORTED_SOURCE_MEDIA_TYPE, this.sourceFileRef.getMediaType());
    }

    public static enum SupportedSourceFormat implements MediaType
    {
        PDF;


        @Override
        public String getMediaType() {
            return ExtensionMediaTypeMapping.valueOf(this.name()).getMediaType().toLowerCase();
        }
    }
}

