/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.pdfops;

import com.adobe.pdfservices.operation.ExecutionContext;
import com.adobe.pdfservices.operation.Operation;
import com.adobe.pdfservices.operation.exception.ServiceApiException;
import com.adobe.pdfservices.operation.exception.ServiceUsageException;
import com.adobe.pdfservices.operation.internal.ExtensionMediaTypeMapping;
import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.MediaType;
import com.adobe.pdfservices.operation.internal.api.FileDownloadApi;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.CPFContentAnalyzerResponse;
import com.adobe.pdfservices.operation.internal.exception.OperationException;
import com.adobe.pdfservices.operation.internal.service.CreatePDFService;
import com.adobe.pdfservices.operation.internal.util.FileUtil;
import com.adobe.pdfservices.operation.internal.util.PathUtil;
import com.adobe.pdfservices.operation.internal.util.StringUtil;
import com.adobe.pdfservices.operation.internal.util.ValidationUtil;
import com.adobe.pdfservices.operation.io.FileRef;
import com.adobe.pdfservices.operation.pdfops.options.createpdf.CreatePDFFromHTMLOptions;
import com.adobe.pdfservices.operation.pdfops.options.createpdf.CreatePDFOptions;
import com.adobe.pdfservices.operation.pdfops.options.createpdf.excel.CreatePDFFromExcelOptions;
import com.adobe.pdfservices.operation.pdfops.options.createpdf.ppt.CreatePDFFromPPTOptions;
import com.adobe.pdfservices.operation.pdfops.options.createpdf.word.CreatePDFFromWordOptions;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatePDFOperation
implements Operation {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreatePDFOperation.class);
    private static final Set<String> SUPPORTED_SOURCE_MEDIA_TYPES = Arrays.stream(SupportedSourceFormat.values()).map(SupportedSourceFormat::getMediaType).collect(Collectors.toSet());
    private static final String TARGET_FILE_EXTENSION = ExtensionMediaTypeMapping.PDF.getExtension();
    private static final Map<ExtensionMediaTypeMapping, Class> mediaTypeOptionClassMap = new HashMap<ExtensionMediaTypeMapping, Class>();
    private boolean isInvoked = false;
    private FileRefImpl sourceFileRef;
    private CreatePDFOptions createPDFOptions;

    private CreatePDFOperation() {
    }

    public static CreatePDFOperation createNew() {
        return new CreatePDFOperation();
    }

    public void setInput(FileRef sourceFileRef) {
        Objects.requireNonNull(sourceFileRef, "No input was set for operation");
        this.sourceFileRef = (FileRefImpl)sourceFileRef;
    }

    public void setOptions(CreatePDFOptions createPdfOptions) {
        this.createPDFOptions = createPdfOptions;
    }

    @Override
    public FileRef execute(ExecutionContext context) throws ServiceApiException, IOException, ServiceUsageException {
        this.validateInvocationCount();
        InternalExecutionContext internalExecutionContext = (InternalExecutionContext)context;
        this.validate(internalExecutionContext);
        try {
            LOGGER.info("All validations successfully done. Beginning CreatePDF operation execution");
            long startTimeMs = System.currentTimeMillis();
            String location = CreatePDFService.convertToPdf(internalExecutionContext, this.sourceFileRef, this.createPDFOptions, this.getClass().getSimpleName());
            String targetFileName = FileUtil.getRandomFileName(TARGET_FILE_EXTENSION);
            String temporaryDestinationPath = PathUtil.getTemporaryDestinationPath(targetFileName, TARGET_FILE_EXTENSION);
            FileDownloadApi.downloadAndSave(internalExecutionContext, location, temporaryDestinationPath, CPFContentAnalyzerResponse.class);
            LOGGER.info("Operation successfully completed. Stored created PDF at {}", (Object)temporaryDestinationPath);
            LOGGER.debug("Operation Success Info - Request ID: {}, Latency(ms): {}", (Object)StringUtil.getRequestIdFromLocation(location), (Object)(System.currentTimeMillis() - startTimeMs));
            this.isInvoked = true;
            return FileRef.createFromLocalFile(temporaryDestinationPath);
        }
        catch (OperationException oe) {
            throw new ServiceApiException(oe.getErrorMessage(), oe.getRequestTrackingId(), oe.getStatusCode(), oe.getReportErrorCode());
        }
    }

    private void validateInvocationCount() {
        if (this.isInvoked) {
            LOGGER.error("Operation instance must only be invoked once");
            throw new IllegalStateException("Operation instance must not be reused, can only be invoked once");
        }
    }

    private void validate(InternalExecutionContext context) {
        if (this.sourceFileRef == null) {
            throw new IllegalArgumentException("No input was set for operation");
        }
        ValidationUtil.validateExecutionContext(context);
        if (this.sourceFileRef.getSourceURL() == null) {
            ValidationUtil.validateMediaType(SUPPORTED_SOURCE_MEDIA_TYPES, this.sourceFileRef.getMediaType());
            if (this.createPDFOptions != null) {
                ValidationUtil.validateOptionInstanceType(mediaTypeOptionClassMap, this.sourceFileRef.getMediaType(), this.createPDFOptions);
            }
        } else if (this.createPDFOptions != null && !(this.createPDFOptions instanceof CreatePDFFromHTMLOptions)) {
            throw new IllegalArgumentException("Invalid option instance type provided for creating PDF from URL");
        }
        if (this.createPDFOptions != null) {
            ValidationUtil.validateOperationOptions(this.createPDFOptions);
        }
    }

    static {
        mediaTypeOptionClassMap.put(ExtensionMediaTypeMapping.ZIP, CreatePDFFromHTMLOptions.class);
        mediaTypeOptionClassMap.put(ExtensionMediaTypeMapping.HTML, CreatePDFFromHTMLOptions.class);
        mediaTypeOptionClassMap.put(ExtensionMediaTypeMapping.DOC, CreatePDFFromWordOptions.class);
        mediaTypeOptionClassMap.put(ExtensionMediaTypeMapping.DOCX, CreatePDFFromWordOptions.class);
        mediaTypeOptionClassMap.put(ExtensionMediaTypeMapping.RTF, CreatePDFFromWordOptions.class);
        mediaTypeOptionClassMap.put(ExtensionMediaTypeMapping.TXT, CreatePDFFromWordOptions.class);
        mediaTypeOptionClassMap.put(ExtensionMediaTypeMapping.XLS, CreatePDFFromExcelOptions.class);
        mediaTypeOptionClassMap.put(ExtensionMediaTypeMapping.XLSX, CreatePDFFromExcelOptions.class);
        mediaTypeOptionClassMap.put(ExtensionMediaTypeMapping.PPT, CreatePDFFromPPTOptions.class);
        mediaTypeOptionClassMap.put(ExtensionMediaTypeMapping.PPTX, CreatePDFFromPPTOptions.class);
    }

    public static enum SupportedSourceFormat implements MediaType
    {
        BMP,
        DOC,
        DOCX,
        GIF,
        HTML,
        JPEG,
        JPG,
        PNG,
        PPT,
        PPTX,
        RTF,
        TIF,
        TIFF,
        TXT,
        XLS,
        XLSX,
        ZIP;


        @Override
        public String getMediaType() {
            return ExtensionMediaTypeMapping.valueOf(this.name()).getMediaType().toLowerCase();
        }
    }
}

