/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.util;

import com.adobe.pdfservices.operation.exception.SdkException;
import com.adobe.pdfservices.operation.internal.ExtensionMediaTypeMapping;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.pagemanipulation.PageAction;
import com.adobe.pdfservices.operation.internal.http.ByteArrayPart;
import com.adobe.pdfservices.operation.internal.http.MultiPartRequest;
import com.adobe.pdfservices.operation.internal.http.StringBodyPart;
import com.adobe.pdfservices.operation.internal.options.CombineOperationInput;
import com.adobe.pdfservices.operation.internal.options.PageRange;
import com.adobe.pdfservices.operation.internal.util.StringUtil;
import com.adobe.pdfservices.operation.pdfops.options.PageRanges;
import com.adobe.pdfservices.operation.pdfops.options.documentmerge.DocumentMergeOptions;
import com.adobe.pdfservices.operation.pdfops.options.protectpdf.EncryptionAlgorithm;
import com.adobe.pdfservices.operation.pdfops.options.protectpdf.PasswordProtectOptions;
import com.adobe.pdfservices.operation.pdfops.options.protectpdf.ProtectPDFOptions;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ValidationUtil {
    private static final long INPUT_FILE_SIZE_LIMIT = 0x6400000L;
    private static final int PASSWORD_MAX_LENGTH = 128;
    private static final int PAGE_ACTIONS_MAX_LIMIT = 200;
    private static final String USER_STRING = "User";
    private static final String OWNER_STRING = "Owner";
    private static final int REMOVE_PROTECTION_PASSWORD_MAX_LENGTH = 150;
    private static final int SPLIT_PDF_OUTPUT_COUNT_LIMIT = 20;
    private static ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();

    public static void validateMediaType(Set<String> allowedMediaTypes, String mediaType) {
        if (mediaType == null || !allowedMediaTypes.contains(mediaType)) {
            throw new IllegalArgumentException("Operation cannot be performed on the specified input media type : " + mediaType);
        }
    }

    public static void validateExecutionContext(InternalExecutionContext context) {
        Objects.requireNonNull(context, "Client Context not initialized before invoking the operation");
        if (context.getClientConfig() == null) {
            throw new IllegalArgumentException("Client Context not initialized before invoking the operation");
        }
        context.validate();
    }

    public static void validateFileWithPageOptions(CombineOperationInput input, Set<String> allowedMimeTypes) {
        ValidationUtil.validateMediaType(allowedMimeTypes, input.getSourceFileRef().getMediaType());
        ValidationUtil.validatePageOptions(input);
    }

    private static void validatePageOptions(CombineOperationInput input) {
        PageRanges pageRanges = input.getPageRanges();
        if (pageRanges == null) {
            throw new IllegalArgumentException("No page options provided for combining files PDFs");
        }
        pageRanges.validate();
    }

    public static void validateOptionInstanceType(Map<ExtensionMediaTypeMapping, Class> mediaTypeOptionClassMap, String sourceMediaType, Object options) {
        Class instanceType = mediaTypeOptionClassMap.get((Object)ExtensionMediaTypeMapping.getFromMimeType(sourceMediaType));
        if (instanceType == null || !instanceType.isInstance(options)) {
            throw new IllegalArgumentException(String.format("Invalid option instance type provided for source media type %s", sourceMediaType));
        }
    }

    public static void validateOptionInstanceType(Set<Class> optionsClassSet, Object options) {
        if (options == null || !optionsClassSet.contains(options.getClass())) {
            throw new IllegalArgumentException("Invalid option instance type provided for the operation");
        }
    }

    public static void validateOperationOptions(Object bean) {
        Validator validator = validatorFactory.getValidator();
        Set violations = validator.validate(bean, new Class[0]);
        if (!violations.isEmpty()) {
            String message = violations.stream().map(ConstraintViolation::getMessage).collect(Collectors.joining("; "));
            throw new IllegalArgumentException(message);
        }
    }

    public static void validateMultiPartBodySize(MultiPartRequest multiPartRequest) {
        double totalSize = 0.0;
        StringBodyPart stringBodyPart = multiPartRequest.getStringBodyPart();
        List<ByteArrayPart> byteArrayParts = multiPartRequest.getByteArrayParts();
        if (stringBodyPart != null && stringBodyPart.getBody() != null) {
            totalSize = stringBodyPart.getBody().getBytes().length;
        }
        if (byteArrayParts != null) {
            for (ByteArrayPart byteArrayPart : byteArrayParts) {
                totalSize += (double)byteArrayPart.getBody().length;
            }
        }
        if (totalSize > 1.048576E8) {
            throw new SdkException("Total input file(s) size exceeds the acceptable limit");
        }
    }

    private static void validatePassword(String password, boolean isUserPassword, String encryptionAlgorithm) {
        if (StringUtil.isEmpty(password)) {
            throw new IllegalArgumentException(String.format("%s Password cannot be empty", isUserPassword ? USER_STRING : OWNER_STRING));
        }
        if (password.length() > 128) {
            throw new IllegalArgumentException(String.format("%s Password length cannot exceed %d bytes", isUserPassword ? USER_STRING : OWNER_STRING, 128));
        }
        if (encryptionAlgorithm.equals(EncryptionAlgorithm.AES_128.getValue()) && !StandardCharsets.ISO_8859_1.newEncoder().canEncode(password)) {
            throw new IllegalArgumentException(String.format("%s Password supports only LATIN-I characters for AES-128 encryption", isUserPassword ? USER_STRING : OWNER_STRING));
        }
    }

    public static void validateProtectPDFOptions(ProtectPDFOptions protectPDFOptions) {
        if (PasswordProtectOptions.class.isInstance(protectPDFOptions)) {
            PasswordProtectOptions passwordProtectOptions = (PasswordProtectOptions)protectPDFOptions;
            if (passwordProtectOptions.getEncryptionAlgorithm() == null) {
                throw new IllegalArgumentException("Encryption algorithm cannot be null");
            }
            if (StringUtil.isNull(passwordProtectOptions.getUserPassword()) && StringUtil.isNull(passwordProtectOptions.getOwnerPassword())) {
                throw new IllegalArgumentException("One of the password (user/owner) is required");
            }
            if (!StringUtil.isNull(passwordProtectOptions.getOwnerPassword()) && !StringUtil.isNull(passwordProtectOptions.getUserPassword()) && passwordProtectOptions.getOwnerPassword().equals(passwordProtectOptions.getUserPassword())) {
                throw new IllegalArgumentException("User and owner password cannot be same");
            }
            if (!StringUtil.isNull(passwordProtectOptions.getUserPassword())) {
                ValidationUtil.validatePassword(passwordProtectOptions.getUserPassword(), true, passwordProtectOptions.getEncryptionAlgorithm().getValue());
            }
            if (!StringUtil.isNull(passwordProtectOptions.getOwnerPassword())) {
                ValidationUtil.validatePassword(passwordProtectOptions.getOwnerPassword(), false, passwordProtectOptions.getEncryptionAlgorithm().getValue());
            }
            if (passwordProtectOptions.getPermissions() != null && StringUtil.isNull(passwordProtectOptions.getOwnerPassword())) {
                throw new IllegalArgumentException("The document permissions cannot be applied without setting owner password");
            }
        }
    }

    public static void validateInsertFilesInputs(Set<String> supportedSourceMediaTypes, Map<Integer, List<CombineOperationInput>> filesToInsert) {
        if (filesToInsert == null || filesToInsert.isEmpty()) {
            throw new IllegalArgumentException("No files to insert in the base input file");
        }
        for (Map.Entry<Integer, List<CombineOperationInput>> entry : filesToInsert.entrySet()) {
            if (entry.getKey() < 1) {
                throw new IllegalArgumentException("Base file page should be greater than 0");
            }
            for (CombineOperationInput combineOperationInput : entry.getValue()) {
                if (combineOperationInput.getSourceFileRef().getSourceURL() != null) {
                    throw new IllegalArgumentException("Input for the Insert Pages Operation can not be sourced from a URL");
                }
                ValidationUtil.validateMediaType(supportedSourceMediaTypes, combineOperationInput.getSourceFileRef().getMediaType());
                ValidationUtil.validatePageRanges(combineOperationInput.getPageRanges());
            }
        }
    }

    public static void validateReplaceFilesInputs(Set<String> supportedSourceMediaTypes, Map<Integer, CombineOperationInput> filesToReplace) {
        if (filesToReplace == null || filesToReplace.isEmpty()) {
            throw new IllegalArgumentException("No files to replace with");
        }
        for (Map.Entry<Integer, CombineOperationInput> entry : filesToReplace.entrySet()) {
            if (entry.getKey() < 1) {
                throw new IllegalArgumentException("Base file page should be greater than 0");
            }
            if (entry.getValue().getSourceFileRef().getSourceURL() != null) {
                throw new IllegalArgumentException("Input for the Replace Pages Operation can not be sourced from a URL");
            }
            ValidationUtil.validateMediaType(supportedSourceMediaTypes, entry.getValue().getSourceFileRef().getMediaType());
            ValidationUtil.validatePageRanges(entry.getValue().getPageRanges());
        }
    }

    public static void validatePageRanges(PageRanges pageRanges) {
        if (pageRanges == null || pageRanges.isEmpty()) {
            throw new IllegalArgumentException("No page ranges were set for the operation");
        }
        pageRanges.validate();
    }

    public static void validatePageRangesOverlap(PageRanges pageRanges) {
        ArrayList<PageRange> pageRangeList = new ArrayList<PageRange>();
        pageRangeList.addAll(pageRanges.getRanges());
        Collections.sort(pageRangeList, Comparator.comparingInt(PageRange::getStart));
        for (int i = 1; i < pageRangeList.size(); ++i) {
            if (((PageRange)pageRangeList.get(i - 1)).getEnd() != null && ((PageRange)pageRangeList.get(i)).getStart() > ((PageRange)pageRangeList.get(i - 1)).getEnd()) continue;
            throw new IllegalArgumentException("The overlapping page ranges are not allowed");
        }
    }

    public static void validateRotatePageActions(List<PageAction> pageActions) {
        if (pageActions.isEmpty()) {
            throw new IllegalArgumentException("No rotation specified for the operation");
        }
        if (pageActions.size() > 200) {
            throw new IllegalArgumentException("Too many rotations not allowed.");
        }
        for (PageAction pageAction : pageActions) {
            if (!pageAction.getPageRanges().isEmpty()) continue;
            throw new IllegalArgumentException("No page ranges were set for the operation");
        }
    }

    public static void validatePasswordToRemoveProtection(String password) {
        if (StringUtil.isNull(password) || StringUtil.isEmpty(password)) {
            throw new IllegalArgumentException("Password cannot be null or empty");
        }
        if (password.length() > 150) {
            throw new IllegalArgumentException(String.format("Allowed maximum length of password is %d characters", 150));
        }
    }

    public static void validateSplitPDFOperationParams(PageRanges pageRanges, Integer pageCount, Integer fileCount) {
        if (pageRanges == null && pageCount == null && fileCount == null) {
            throw new IllegalArgumentException("One of the options(page ranges/file count/page count) is required for splitting a PDF document");
        }
        if (pageRanges != null) {
            if (pageCount != null || fileCount != null) {
                throw new IllegalArgumentException("Only one of option (page ranges/page count/file count) can be specified for splitting a PDF document");
            }
            if (pageRanges.getRanges().size() > 20) {
                throw new IllegalArgumentException("Too many page ranges specified");
            }
            ValidationUtil.validatePageRangesOverlap(pageRanges);
            pageRanges.validate();
            return;
        }
        if (pageCount != null) {
            if (fileCount != null) {
                throw new IllegalArgumentException("Only one of option (page ranges/page count/file count) can be specified for splitting a PDF document");
            }
            if (pageCount <= 0) {
                throw new IllegalArgumentException("Page count should be greater than 0");
            }
            return;
        }
        if (fileCount <= 0) {
            throw new IllegalArgumentException("File count should be greater than 0");
        }
        if (fileCount > 20) {
            throw new IllegalArgumentException(String.format("Input PDF file cannot be split into more than %d documents", 20));
        }
    }

    public static void validateDocumentMergeOptions(DocumentMergeOptions documentMergeOptions) {
        if (documentMergeOptions.getJsonDataForMerge() == null) {
            throw new IllegalArgumentException("Input json data cannot be null");
        }
        if (documentMergeOptions.getJsonDataForMerge().length() == 0) {
            throw new IllegalArgumentException("Input JSON Data cannot be null or empty");
        }
        if (documentMergeOptions.getOutputFormat() == null) {
            throw new IllegalArgumentException("Output format cannot be null");
        }
    }
}

