/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.service;

import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.api.CPFApi;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.CPFContentAnalyzerRequests;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.Inputs;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.RotatePagesParams;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.pagemanipulation.PageAction;
import com.adobe.pdfservices.operation.internal.http.HttpResponse;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;

public class RotatePagesService {
    private static final String OUTPUT_FORMAT_SPECIFIER = "application/pdf";

    public static String rotatePages(InternalExecutionContext context, FileRefImpl sourceFileRef, List<PageAction> pageActions, String operation) throws FileNotFoundException {
        RotatePagesParams rotatePagesParams = RotatePagesParams.createFrom(pageActions);
        Inputs inputs = Inputs.builder(OUTPUT_FORMAT_SPECIFIER).setParams(rotatePagesParams).build();
        CPFContentAnalyzerRequests cpfContentAnalyzerRequests = new CPFContentAnalyzerRequests("urn:aaid:cpf:Service-4735fcf3cf924b25879e6fcf7aa84ad4", inputs, OUTPUT_FORMAT_SPECIFIER);
        ArrayList<FileRefImpl> sourceFileRefList = new ArrayList<FileRefImpl>();
        sourceFileRefList.add(sourceFileRef);
        HttpResponse<String> response = CPFApi.cpfCreateOpsApi(context, cpfContentAnalyzerRequests, sourceFileRefList, String.class, operation);
        return response.getHeaders().get("location");
    }
}

