/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.service;

import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.options.CombineOperationInput;
import com.adobe.pdfservices.operation.internal.service.CombinePDFService;
import com.adobe.pdfservices.operation.pdfops.options.PageRanges;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ReplacePagesService
extends CombinePDFService {
    private static final int INPUT_SOURCE_LIMIT = 20;

    private static ReplaceFilesInput getFilesToReplace(FileRefImpl baseFileRef, Map<Integer, CombineOperationInput> filesToReplace) throws IOException {
        ArrayList<FileRefImpl> fileRefList = new ArrayList<FileRefImpl>();
        ArrayList<PageRanges> pageRangeList = new ArrayList<PageRanges>();
        int baseFileStartIndex = 1;
        for (Map.Entry<Integer, CombineOperationInput> entry : filesToReplace.entrySet()) {
            if (entry.getKey() != baseFileStartIndex) {
                fileRefList.add(baseFileRef.getCopy());
                PageRanges pageRanges = new PageRanges();
                pageRanges.addRange(baseFileStartIndex, entry.getKey() - 1);
                pageRangeList.add(pageRanges);
            }
            fileRefList.add(entry.getValue().getSourceFileRef());
            pageRangeList.add(entry.getValue().getPageRanges());
            baseFileStartIndex = entry.getKey() + 1;
        }
        fileRefList.add(baseFileRef);
        PageRanges basePageRanges = new PageRanges();
        basePageRanges.addAllFrom(baseFileStartIndex);
        pageRangeList.add(basePageRanges);
        return new ReplaceFilesInput(fileRefList, pageRangeList);
    }

    public static String replacePages(InternalExecutionContext context, FileRefImpl baseFileRef, Map<Integer, CombineOperationInput> filesToReplace, String operation) throws IOException {
        ReplaceFilesInput replaceFilesInput = ReplacePagesService.getFilesToReplace(baseFileRef, filesToReplace);
        List sourceFileRefList = replaceFilesInput.fileRefList;
        if (sourceFileRefList.size() > 20) {
            throw new IllegalArgumentException("Too many replacements specified for the operation");
        }
        return ReplacePagesService.execute(context, operation, replaceFilesInput.pageRangesList, sourceFileRefList, sourceFileRefList.size());
    }

    private static class ReplaceFilesInput {
        private List<FileRefImpl> fileRefList;
        private List<PageRanges> pageRangesList;

        ReplaceFilesInput(List<FileRefImpl> fileRefList, List<PageRanges> pageRangesList) {
            this.fileRefList = fileRefList;
            this.pageRangesList = pageRangesList;
        }
    }
}

