/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.service;

import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.api.CPFApi;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.CPFContentAnalyzerRequests;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.Inputs;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.OCRParams;
import com.adobe.pdfservices.operation.internal.http.HttpResponse;
import com.adobe.pdfservices.operation.pdfops.options.ocr.OCROptions;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public class OCRService {
    private static final String OUTPUT_FORMAT_SPECIFIER = "application/pdf";

    public static String performOCROnPDF(InternalExecutionContext context, FileRefImpl sourceFileRef, OCROptions ocrOptions, String operation) throws FileNotFoundException {
        OCRParams ocrParams = OCRParams.createFrom(ocrOptions);
        Inputs inputs = Inputs.builder(sourceFileRef.getMediaType()).setParams(ocrParams).build();
        CPFContentAnalyzerRequests cpfContentAnalyzerRequests = new CPFContentAnalyzerRequests("urn:aaid:cpf:Service-7e6a5d2b6bb141d7832398076914a07b", inputs, OUTPUT_FORMAT_SPECIFIER);
        ArrayList<FileRefImpl> sourceFileRefList = new ArrayList<FileRefImpl>();
        sourceFileRefList.add(sourceFileRef);
        HttpResponse<String> response = CPFApi.cpfCreateOpsApi(context, cpfContentAnalyzerRequests, sourceFileRefList, String.class, operation);
        return response.getHeaders().get("location");
    }
}

