/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.service.ExtractPDFService;

import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.ExtractPDF.ExtractPDFOutput;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.ExtractPDF.ExtractRenditionOutput;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.ExtractPDF.StructuredData;
import com.adobe.pdfservices.operation.internal.util.FileUtil;
import com.adobe.pdfservices.operation.internal.util.JsonUtil;
import com.adobe.pdfservices.operation.internal.util.PathUtil;
import com.adobe.pdfservices.operation.internal.util.StringUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.apache.commons.collections4.CollectionUtils;

public class ExtractDataZipper {
    private static void zipExtractedRenditions(ZipOutputStream zipOutputStream, List<ExtractRenditionOutput> extractRenditionOutputs) throws IOException {
        if (CollectionUtils.isNotEmpty(extractRenditionOutputs)) {
            for (ExtractRenditionOutput extractRenditionOutput : extractRenditionOutputs) {
                String fileName = PathUtil.getFileNameWithExtension(extractRenditionOutput.getFileName(), extractRenditionOutput.getRenditionExtension());
                String folderName = "renditions";
                if (StringUtil.isBlank(fileName)) {
                    fileName = FileUtil.getRandomFileName(extractRenditionOutput.getRenditionExtension());
                }
                if (extractRenditionOutput.getRenditionsElementType() != null) {
                    folderName = extractRenditionOutput.getRenditionsElementType().name().toLowerCase();
                }
                fileName = PathUtil.getSubPath(folderName, fileName);
                FileUtil.addZipEntry(zipOutputStream, fileName, extractRenditionOutput.getInputStream());
            }
        }
    }

    private static void zipExtractedStructuredData(ZipOutputStream zipOutputStream, StructuredData structuredData) throws IOException {
        String fileName = structuredData.getFileName();
        FileUtil.addZipEntry(zipOutputStream, fileName, JsonUtil.convertMapToString(structuredData.getData().toMap()).getBytes("UTF-8"));
    }

    public static void zipExtractOutput(ExtractPDFOutput extractPDFOutput, String destinationPath) throws IOException {
        try (ZipOutputStream zipOutputStream = null;){
            FileOutputStream fileOutputStream = new FileOutputStream(destinationPath);
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            ExtractDataZipper.zipExtractedStructuredData(zipOutputStream, extractPDFOutput.getStructuredElementData());
            ExtractDataZipper.zipExtractedRenditions(zipOutputStream, extractPDFOutput.getExtractedRenditions());
        }
    }
}

