/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.service.ExtractPDFService;

import com.adobe.pdfservices.operation.exception.SdkException;
import com.adobe.pdfservices.operation.internal.ExtensionMediaTypeMapping;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.MultiPartFormField;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.ExtractPDF.ExtractContentAnalyzerResponse;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.ExtractPDF.ExtractOutputMetaData;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.ExtractPDF.ExtractPDFOutput;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.ExtractPDF.ExtractRenditionOutput;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.ExtractPDF.StructuredData;
import com.adobe.pdfservices.operation.internal.util.JsonUtil;
import com.adobe.pdfservices.operation.internal.util.PathUtil;
import com.adobe.pdfservices.operation.internal.util.StringUtil;
import com.adobe.pdfservices.operation.pdfops.options.extractpdf.ExtractRenditionsElementType;
import java.io.IOException;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;

public class ExtractDataParser {
    private static ExtractRenditionOutput frameExtractRenditionOutput(ExtractOutputMetaData extractOutputMetaData, StructuredData structuredData, MimeBodyPart bodyPart) throws MessagingException, IOException {
        ExtractRenditionOutput renditionOutput = null;
        String fileName = StringUtil.getKeyFromDelimitedString(bodyPart.getHeader("Content-Disposition", ";"), "name", ";");
        if (extractOutputMetaData.getIndexedMetaInfo() != null && StringUtil.isNotBlank(fileName) && structuredData != null) {
            renditionOutput = new ExtractRenditionOutput();
            renditionOutput.setFileName(fileName);
            MultiPartFormField multiPartFormField = extractOutputMetaData.getIndexedMetaInfo().get(fileName);
            String fileFormat = multiPartFormField.getFormat();
            String extension = ExtensionMediaTypeMapping.getFromMimeType(fileFormat).getExtension();
            extension = extension != null ? extension : "unknown";
            renditionOutput.setRenditionExtension(extension);
            renditionOutput.setInputStream(bodyPart.getInputStream());
            ExtractRenditionsElementType extractElementType = structuredData.getRenditionElementType(PathUtil.getFileNameWithExtension(fileName, extension));
            renditionOutput.setRenditionsElementType(extractElementType);
        }
        return renditionOutput;
    }

    public static ExtractPDFOutput frameExtractSpecificOutput(List<MimeBodyPart> responseBodyParts) throws MessagingException, SdkException, IOException {
        String contentName;
        ExtractOutputMetaData extractOutputMetaData = null;
        StructuredData structuredData = null;
        ExtractPDFOutput extractPDFOutput = new ExtractPDFOutput();
        for (MimeBodyPart bodyPart : responseBodyParts) {
            contentName = StringUtil.getKeyFromDelimitedString(bodyPart.getHeader("Content-Disposition", ":"), "name", ";");
            if (bodyPart.isMimeType(ExtensionMediaTypeMapping.JSON.getMediaType()) && StringUtil.isNotBlank(contentName) && contentName.startsWith("contentAnalyzerResponse")) {
                ExtractContentAnalyzerResponse extractContentAnalyzerResponse = JsonUtil.deserializeJsonStream(bodyPart.getInputStream(), ExtractContentAnalyzerResponse.class);
                extractOutputMetaData = extractContentAnalyzerResponse.getExtractOutputMetaData();
                extractPDFOutput.setCpfContentAnalyzerResponse(extractContentAnalyzerResponse);
                continue;
            }
            if (!StringUtil.isNotBlank(contentName) || !contentName.startsWith("jsonoutput") || extractOutputMetaData == null || !extractOutputMetaData.getIndexedMetaInfo().get(contentName).getFormat().equals(ExtensionMediaTypeMapping.JSON.getMediaType())) continue;
            structuredData = StructuredData.deserializeData(bodyPart.getInputStream(), ExtensionMediaTypeMapping.JSON);
            extractPDFOutput.setStructuredElementData(structuredData);
        }
        for (MimeBodyPart bodyPart : responseBodyParts) {
            ExtractRenditionOutput renditionOutput;
            contentName = StringUtil.getKeyFromDelimitedString(bodyPart.getHeader("Content-Disposition", ":"), "name", ";");
            if (!bodyPart.isMimeType("application/octet-stream") || !StringUtil.isNotBlank(contentName) || !contentName.startsWith("fileoutpart") || (renditionOutput = ExtractDataParser.frameExtractRenditionOutput(extractOutputMetaData, structuredData, bodyPart)) == null) continue;
            extractPDFOutput.addExtractedRendition(renditionOutput);
        }
        return extractPDFOutput;
    }
}

