/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.http;

import com.adobe.pdfservices.operation.exception.SdkException;
import com.adobe.pdfservices.operation.internal.auth.AuthenticationMethod;
import com.adobe.pdfservices.operation.internal.auth.Authenticator;
import com.adobe.pdfservices.operation.internal.auth.SessionToken;
import com.adobe.pdfservices.operation.internal.cpf.constants.RequestKey;
import com.adobe.pdfservices.operation.internal.http.HttpMethod;
import com.adobe.pdfservices.operation.internal.http.HttpRequest;
import com.adobe.pdfservices.operation.internal.http.HttpRequestConfig;
import com.adobe.pdfservices.operation.internal.http.RequestType;
import com.github.hal4j.uritemplate.URITemplate;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.http.Consts;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.StringEntity;

public class BaseHttpRequest
implements HttpRequest {
    private URITemplate uriTemplate;
    private HttpMethod httpMethod;
    private RequestType requestType;
    private Map<String, String> headers;
    private AuthenticationMethod authenticationMethod;
    private StringEntity entity;
    private Authenticator authenticator;
    private RequestKey requestKey;
    private HttpRequestConfig requestConfig;

    public BaseHttpRequest(String requestKey, HttpMethod httpMethod, String uriTemplate) {
        Objects.requireNonNull(requestKey);
        Objects.requireNonNull(httpMethod);
        Objects.requireNonNull(uriTemplate);
        this.httpMethod = httpMethod;
        this.uriTemplate = new URITemplate(uriTemplate);
        this.headers = new HashMap<String, String>();
        this.authenticationMethod = AuthenticationMethod.AUTH_HEADER_PRIMARY;
        this.requestType = RequestType.REGULAR;
        this.requestKey = RequestKey.getRequestKeyFromValue(requestKey);
    }

    public BaseHttpRequest(HttpMethod httpMethod) {
        Objects.requireNonNull(httpMethod);
        this.httpMethod = httpMethod;
        this.headers = new HashMap<String, String>();
        this.authenticationMethod = AuthenticationMethod.AUTH_HEADER_PRIMARY;
        this.requestType = RequestType.REGULAR;
        this.requestKey = null;
    }

    @Override
    public HttpRequest withContentType(String contentType) {
        return this.withHeader("Content-Type", contentType);
    }

    @Override
    public HttpRequest withHeader(String headerName, String headerValue) {
        this.headers.put(headerName, headerValue);
        return this;
    }

    @Override
    public HttpRequest withHeaders(Map<String, String> headers) {
        Map<String, String> headersCopy = this.getHeadersCopy(headers);
        this.headers.putAll(headersCopy);
        return this;
    }

    @Override
    public HttpRequest withUriParam(String name, String value) {
        return null;
    }

    @Override
    public HttpRequest withUrlEncodedFormParams(List<NameValuePair> formParams) {
        this.entity = new UrlEncodedFormEntity(formParams, Consts.UTF_8);
        return this;
    }

    @Override
    public HttpRequest withBody(String body) {
        try {
            this.entity = new StringEntity(body);
        }
        catch (UnsupportedEncodingException e) {
            throw new SdkException(String.format("Internal error in creating http request: %s", body), e);
        }
        return this;
    }

    @Override
    public HttpRequest withAuthenticationMethod(AuthenticationMethod authMethod) {
        this.authenticationMethod = authMethod;
        return this;
    }

    @Override
    public HttpRequest withAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
        this.headers.put("x-api-key", this.authenticator.getClientId());
        return this;
    }

    @Override
    public HttpRequest withConfig(HttpRequestConfig requestConfig) {
        this.requestConfig = requestConfig;
        return this;
    }

    @Override
    public HttpRequest withRequestKey(RequestKey requestKey) {
        this.requestKey = requestKey;
        return this;
    }

    @Override
    public void authenticate() {
        if (this.authenticationMethod.isAuthRequired()) {
            if (this.authenticator == null) {
                throw new IllegalStateException("No authenticator provided for request. Cannot add authorization headers");
            }
            SessionToken sessionToken = this.authenticator.getSessionToken(this.requestConfig);
            this.withHeader("Authorization", String.format("Bearer %s", sessionToken.getAccessToken()));
        }
    }

    @Override
    public void forceAuthenticate() {
        if (this.authenticationMethod.isAuthRequired()) {
            if (this.authenticator == null) {
                throw new IllegalStateException("No authenticator provided for request. Cannot add authorization headers");
            }
            SessionToken sessionToken = this.authenticator.refreshSessionToken(this.requestConfig);
            this.withHeader("Authorization", String.format("Bearer %s", sessionToken.getAccessToken()));
        }
    }

    @Override
    public HttpRequestConfig getConfig() {
        return this.requestConfig;
    }

    @Override
    public HttpRequest withTemplate(String uriTemplate) {
        this.uriTemplate = new URITemplate(uriTemplate);
        return this;
    }

    @Override
    public HttpRequest withAcceptType(String acceptHeader) {
        return this.withHeader("Accept", acceptHeader);
    }

    @Override
    public StringEntity getEntity() {
        return this.entity;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public AuthenticationMethod getAuthMethod() {
        return this.authenticationMethod;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.getHeadersCopy(this.headers);
    }

    @Override
    public String getFinalUri() {
        return this.uriTemplate.expand(new Object[0]).toString();
    }

    @Override
    public String getTemplateString() {
        return this.uriTemplate.toString();
    }

    @Override
    public RequestType getRequestType() {
        return this.requestType;
    }

    @Override
    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    private Map<String, String> getHeadersCopy(Map<String, String> headersToCopy) {
        return headersToCopy.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public RequestKey getRequestKey() {
        return this.requestKey;
    }
}

