/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.http;

import com.adobe.pdfservices.operation.internal.http.ByteArrayPart;
import com.adobe.pdfservices.operation.internal.http.HttpRequest;
import com.adobe.pdfservices.operation.internal.http.HttpRequestConfig;
import com.adobe.pdfservices.operation.internal.http.InputStreamPart;
import com.adobe.pdfservices.operation.internal.http.MultiPartRequest;
import com.adobe.pdfservices.operation.internal.http.RequestType;
import com.adobe.pdfservices.operation.internal.http.StringBodyPart;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApacheHttpUtil.class);

    public static HttpUriRequest getApacheRequest(HttpRequest httpRequest) {
        HttpGet apacheHttpRequest = null;
        switch (httpRequest.getHttpMethod()) {
            case GET: {
                LOGGER.debug("Creating apache http get request for {}", (Object)httpRequest.getRequestKey());
                apacheHttpRequest = ApacheHttpUtil.createGetRequest(httpRequest);
                break;
            }
            case POST: {
                LOGGER.debug("Creating apache http post request for {}", (Object)httpRequest.getRequestKey());
                RequestType requestType = httpRequest.getRequestType();
                if (requestType.equals((Object)RequestType.REGULAR)) {
                    apacheHttpRequest = ApacheHttpUtil.createPostRequest(httpRequest);
                    break;
                }
                apacheHttpRequest = ApacheHttpUtil.createMultiPartRequest((MultiPartRequest)httpRequest);
                break;
            }
        }
        return apacheHttpRequest;
    }

    private static HttpGet createGetRequest(HttpRequest httpRequest) {
        HttpGet apacheHttpGet = new HttpGet(httpRequest.getFinalUri());
        ApacheHttpUtil.setRequestConfig(httpRequest, (HttpRequestBase)apacheHttpGet);
        httpRequest.getHeaders().forEach((arg_0, arg_1) -> ((HttpGet)apacheHttpGet).setHeader(arg_0, arg_1));
        return apacheHttpGet;
    }

    private static void setRequestConfig(HttpRequest httpRequest, HttpRequestBase httpRequestBase) {
        HttpRequestConfig requestConfig = httpRequest.getConfig();
        if (requestConfig != null) {
            RequestConfig.Builder apacheRequestConfigBuilder = RequestConfig.custom().setConnectTimeout(requestConfig.getConnectTimeout()).setSocketTimeout(requestConfig.getSocketTimeout());
            if (requestConfig.getProxyHost() != null) {
                HttpHost proxy = new HttpHost(requestConfig.getProxyHost(), requestConfig.getProxyPort().intValue(), requestConfig.getProxyScheme());
                apacheRequestConfigBuilder.setProxy(proxy);
            }
            httpRequestBase.setConfig(apacheRequestConfigBuilder.build());
        }
    }

    private static HttpPost createPostRequest(HttpRequest httpRequest) {
        HttpPost apacheHttpPost = new HttpPost(httpRequest.getFinalUri());
        if (httpRequest.getEntity() != null) {
            apacheHttpPost.setEntity((HttpEntity)httpRequest.getEntity());
        }
        ApacheHttpUtil.setRequestConfig(httpRequest, (HttpRequestBase)apacheHttpPost);
        httpRequest.getHeaders().forEach((arg_0, arg_1) -> ((HttpPost)apacheHttpPost).setHeader(arg_0, arg_1));
        return apacheHttpPost;
    }

    private static HttpPost createMultiPartRequest(MultiPartRequest multiPartRequest) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        HttpPost apacheHttpMultipartRequest = new HttpPost(multiPartRequest.getFinalUri());
        List<ByteArrayPart> byteArrayParts = multiPartRequest.getByteArrayParts();
        List<InputStreamPart> inputStreamParts = multiPartRequest.getInputStreams();
        StringBodyPart bodyPart = multiPartRequest.getStringBodyPart();
        if (bodyPart != null) {
            builder.addPart(bodyPart.getName(), (ContentBody)new StringBody(bodyPart.getBody(), ContentType.create((String)bodyPart.getContentType(), (Charset)StandardCharsets.UTF_8)));
        }
        if (byteArrayParts != null) {
            for (ByteArrayPart byteArrayPart : byteArrayParts) {
                ByteArrayBody byteArrayBody = new ByteArrayBody(byteArrayPart.getBody(), byteArrayPart.getFileName());
                builder.addPart(byteArrayPart.getName(), (ContentBody)byteArrayBody);
            }
        }
        if (inputStreamParts != null) {
            LOGGER.debug("Added input stream part {} request", (Object)multiPartRequest.getRequestKey());
            for (InputStreamPart inputStreamPart : inputStreamParts) {
                builder.addBinaryBody(inputStreamPart.getName(), inputStreamPart.getInputStream(), ContentType.APPLICATION_OCTET_STREAM, inputStreamPart.getFileName());
            }
        }
        HttpEntity build = builder.build();
        apacheHttpMultipartRequest.setEntity(build);
        ApacheHttpUtil.setRequestConfig(multiPartRequest, (HttpRequestBase)apacheHttpMultipartRequest);
        multiPartRequest.getHeaders().forEach((arg_0, arg_1) -> ((HttpPost)apacheHttpMultipartRequest).setHeader(arg_0, arg_1));
        return apacheHttpMultipartRequest;
    }

    static Map<String, String> getHeaders(Header[] headers) {
        return Arrays.stream(headers).collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue, (key1, key2) -> key1));
    }
}

