/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.cpf.dto.request.platform;

import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.CPFParams;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.MultiPartFormField;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.PlatformParams;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.multipleInputsField.CPFMultipleInputsField;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URL;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Inputs {
    @JsonProperty(value="documentIn")
    private MultiPartFormField multiPartFormField;
    @JsonProperty(value="documentsIn")
    private List<CPFMultipleInputsField> cpfMultipleInputsFields;
    @JsonProperty(value="params")
    private CPFParams cpfParams;
    @JsonProperty(value="inputUrl")
    private String sourceUrl;

    private Inputs(MultiPartFormField multiPartFormField, CPFParams cpfParams) {
        this.multiPartFormField = multiPartFormField;
        this.cpfParams = cpfParams;
    }

    public Inputs(List<CPFMultipleInputsField> cpfMultipleInputsFields) {
        this.cpfMultipleInputsFields = cpfMultipleInputsFields;
    }

    public Inputs(URL sourceUrl, CPFParams cpfParams) {
        this.sourceUrl = sourceUrl.toString();
        this.cpfParams = cpfParams;
    }

    public static Builder builder(String inputFormat) {
        return new Builder(inputFormat);
    }

    public static class Builder {
        private static final String FILE_FORM_FIELD_NAME = "file1";
        private String inputFormat;
        private URL sourceUrl;
        private PlatformParams params;
        private CPFParams cpfParams;

        public Builder(String inputFormat) {
            this.inputFormat = inputFormat;
        }

        public Builder setParams(PlatformParams params) {
            this.params = params;
            return this;
        }

        public Builder setSourceUrl(URL sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public Inputs build() {
            if (this.params != null) {
                this.cpfParams = new CPFParams(this.params);
            }
            if (this.sourceUrl != null) {
                return new Inputs(this.sourceUrl, this.cpfParams);
            }
            return new Inputs(new MultiPartFormField(this.inputFormat, FILE_FORM_FIELD_NAME), this.cpfParams);
        }
    }
}

