/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.cpf.constants;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum RequestKey {
    CREATE("cpf.create"),
    STATUS("cpf.status"),
    AUTHN("ims.session_token");

    private String value;
    private static final Map<String, RequestKey> REQUEST_KEY_MAP;

    private RequestKey(String value) {
        this.value = value;
    }

    public static RequestKey getRequestKeyFromValue(String value) {
        return REQUEST_KEY_MAP.get(value);
    }

    public String getValue() {
        return this.value;
    }

    static {
        HashMap<String, RequestKey> map = new HashMap<String, RequestKey>();
        for (RequestKey requestKey : RequestKey.values()) {
            map.put(requestKey.getValue(), requestKey);
        }
        REQUEST_KEY_MAP = Collections.unmodifiableMap(map);
    }
}

