/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal;

import com.adobe.pdfservices.operation.internal.ExtensionMediaTypeMapping;
import com.adobe.pdfservices.operation.internal.util.FileUtil;
import com.adobe.pdfservices.operation.internal.util.PathUtil;
import com.adobe.pdfservices.operation.internal.util.StringUtil;
import com.adobe.pdfservices.operation.io.FileRef;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRefImpl
extends FileRef {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileRef.class);
    private String mediaType;
    private String localSource;
    private URL sourceUrl;
    private String name;
    private InputStream inputStream;
    private String extension;
    private byte[] fileByteArray;

    public FileRefImpl(String localSource, String mediaType) {
        Objects.requireNonNull(localSource, "Source file path must not be null");
        Objects.requireNonNull(mediaType, "Source file mediaType must not be null");
        this.localSource = localSource;
        this.mediaType = mediaType;
        this.name = PathUtil.getFileName(localSource);
        this.initializeExtension();
    }

    public FileRefImpl(InputStream inputStream, String mediaType) {
        Objects.requireNonNull(inputStream, "Source inputStream must not be null");
        Objects.requireNonNull(mediaType, "Source file mediaType must not be null");
        this.inputStream = inputStream;
        this.mediaType = mediaType;
        this.initializeExtension();
    }

    public FileRefImpl(String localSource) {
        Objects.requireNonNull(localSource, "Source file path must not be null");
        this.localSource = localSource;
        this.name = PathUtil.getFileName(localSource);
        this.extension = PathUtil.getExtension(localSource);
        ExtensionMediaTypeMapping mediaTypeMapping = ExtensionMediaTypeMapping.getFromExtension(this.extension);
        this.mediaType = mediaTypeMapping == null ? null : mediaTypeMapping.getMediaType();
    }

    public FileRefImpl(URL url) {
        Objects.requireNonNull(url, "Source file URL must not be null");
        this.sourceUrl = url;
    }

    private void initializeExtension() {
        ExtensionMediaTypeMapping mediaTypeMapping = ExtensionMediaTypeMapping.getFromMimeType(this.getMediaType());
        if (mediaTypeMapping != null) {
            this.extension = mediaTypeMapping.getExtension();
        }
    }

    public String getLocalPath() {
        return this.localSource;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileRefImpl fileRefImpl = (FileRefImpl)o;
        return Objects.equals(this.localSource, fileRefImpl.localSource) && Objects.equals(this.extension, fileRefImpl.extension) && Objects.equals(this.mediaType, fileRefImpl.mediaType) && Objects.equals(this.inputStream, fileRefImpl.inputStream) && Objects.equals(this.sourceUrl, fileRefImpl.sourceUrl) && Objects.equals(this.name, fileRefImpl.name);
    }

    public int hashCode() {
        return Objects.hash(this.localSource, this.extension, this.mediaType, this.inputStream, this.name);
    }

    public InputStream getAsStream() throws FileNotFoundException {
        if (this.localSource != null) {
            return new FileInputStream(this.localSource);
        }
        if (this.inputStream != null) {
            return this.inputStream;
        }
        return null;
    }

    public byte[] getByteArray() throws IOException {
        if (this.fileByteArray == null) {
            InputStream is = this.getAsStream();
            try {
                this.fileByteArray = IOUtils.toByteArray((InputStream)is);
            }
            finally {
                if (StringUtil.isNotBlank(this.getLocalPath())) {
                    is.close();
                }
            }
        }
        return this.fileByteArray;
    }

    public String getExtension() {
        return this.extension;
    }

    public URL getSourceURL() {
        return this.sourceUrl;
    }

    private void moveFile(String targetLocation) throws IOException {
        if (!this.isOperationResult(this.localSource)) {
            LOGGER.error("Invalid use of saveAs(). Method invoked on FileRef instance which does not point to an operation result");
            throw new UnsupportedOperationException("Method saveAs only allowed on operation results");
        }
        LOGGER.info("Moving file at {} to target {}", (Object)this.localSource, (Object)targetLocation);
        String targetFileName = PathUtil.getFileNameWithExtension(PathUtil.getBaseName(targetLocation), this.getExtension());
        String destinationPath = String.format("%s%s", PathUtil.getFullPath(targetLocation), targetFileName);
        FileUtil.moveFile(this.getLocalPath(), destinationPath);
    }

    private boolean isOperationResult(String localSource) {
        return localSource != null && localSource.contains(PathUtil.getTemporaryDirectoryPath());
    }

    private void moveFile(OutputStream outputStream) throws IOException {
        if (!this.isOperationResult(this.localSource)) {
            LOGGER.error("Invalid use of saveAs(). Method invoked on FileRef instance which does not point to an operation result");
            throw new UnsupportedOperationException("Method saveAs only allowed on operation results");
        }
        LOGGER.info("Writing file at {} to output stream", (Object)this.localSource);
        FileUtil.moveFileToStream(this.localSource, outputStream);
    }

    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public void saveAs(String targetLocation) throws IOException {
        Objects.requireNonNull(targetLocation, "Target location must not be null");
        this.moveFile(targetLocation);
    }

    @Override
    public void saveAs(OutputStream outputStream) throws IOException {
        Objects.requireNonNull(outputStream, "OutputStream must not be null");
        this.moveFile(outputStream);
    }

    public FileRefImpl getCopy() throws IOException {
        byte[] byteArray = Objects.nonNull(this.fileByteArray) ? this.fileByteArray : this.getByteArray();
        ByteArrayInputStream targetStream = new ByteArrayInputStream(byteArray);
        ByteArrayInputStream internalStream = new ByteArrayInputStream(byteArray);
        this.inputStream = internalStream;
        return new FileRefImpl(targetStream, this.mediaType);
    }
}

