/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal;

public enum ExtensionMediaTypeMapping {
    AI("application/illustrator"),
    BMP("image/bmp"),
    DOC("application/msword"),
    DOCX("application/vnd.openxmlformats-officedocument.wordprocessingml.document"),
    GIF("image/gif"),
    HTML("text/html"),
    INDD("application/x-indesign"),
    JPEG("image/jpeg"),
    JPG("image/jpeg"),
    PDF("application/pdf"),
    PNG("image/png"),
    PPT("application/vnd.ms-powerpoint"),
    PPTX("application/vnd.openxmlformats-officedocument.presentationml.presentation"),
    PSD("image/vnd.adobe.photoshop"),
    RTF("text/rtf"),
    TIF("image/tiff"),
    TIFF("image/tiff"),
    TXT("text/plain"),
    XLS("application/vnd.ms-excel"),
    XLSX("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"),
    ZIP("application/zip"),
    JSON("application/json"),
    CSV("text/csv");

    private final String mimeType;

    private ExtensionMediaTypeMapping(String mimeType) {
        this.mimeType = mimeType;
    }

    public static ExtensionMediaTypeMapping getFromMimeType(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        for (ExtensionMediaTypeMapping extensionMediaTypeMapping : ExtensionMediaTypeMapping.values()) {
            if (!extensionMediaTypeMapping.getMediaType().equalsIgnoreCase(mimeType)) continue;
            return extensionMediaTypeMapping;
        }
        return null;
    }

    public static ExtensionMediaTypeMapping getFromExtension(String extension) {
        if (extension == null) {
            return null;
        }
        for (ExtensionMediaTypeMapping extensionMediaTypeMapping : ExtensionMediaTypeMapping.values()) {
            if (!extensionMediaTypeMapping.getExtension().equalsIgnoreCase(extension)) continue;
            return extensionMediaTypeMapping;
        }
        return null;
    }

    public String getMediaType() {
        return this.mimeType;
    }

    public String getExtension() {
        return this.name().toLowerCase();
    }
}

