/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal;

import com.adobe.pdfservices.operation.internal.GlobalConfig;
import com.adobe.pdfservices.operation.internal.cpf.constants.RequestKey;
import com.adobe.pdfservices.operation.internal.http.BaseHttpRequest;
import com.adobe.pdfservices.operation.internal.http.BaseMultipartRequest;
import com.adobe.pdfservices.operation.internal.http.HttpMethod;
import com.adobe.pdfservices.operation.internal.http.HttpRequest;
import com.adobe.pdfservices.operation.internal.http.RequestType;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class CPFServiceRequestContext {
    private static final String ACCEPT_HEADER_VALUE = "application/json, text/plain, */*";
    private static final String RESPOND_WITH_QUERY_PARAM = "respondWith";
    private Map<RequestKey, HttpRequest> baseRequestMap = new HashMap<RequestKey, HttpRequest>();

    public CPFServiceRequestContext(String cpfServiceOpsCreateUri) {
        this.baseRequestMap.put(RequestKey.CREATE, new BaseMultipartRequest(cpfServiceOpsCreateUri).withRequestKey(RequestKey.CREATE));
        this.baseRequestMap.put(RequestKey.STATUS, new BaseHttpRequest(HttpMethod.GET).withRequestKey(RequestKey.STATUS));
    }

    public synchronized HttpRequest getBaseRequest(RequestKey requestKey) {
        HttpRequest baseRequest = this.baseRequestMap.get((Object)requestKey);
        return this.copy(baseRequest);
    }

    private HttpRequest copy(HttpRequest httpRequest) {
        RequestType requestType = httpRequest.getRequestType();
        HttpRequest httpRequestCopy = null;
        switch (requestType) {
            case REGULAR: {
                httpRequestCopy = new BaseHttpRequest(httpRequest.getHttpMethod()).withRequestKey(httpRequest.getRequestKey()).withHeaders(this.getDefaultHeaders());
                break;
            }
            case MULTIPART: {
                try {
                    httpRequestCopy = new BaseMultipartRequest(httpRequest.getTemplateString() + String.format("?%s=%s", RESPOND_WITH_QUERY_PARAM, URLEncoder.encode("{\"reltype\": \"http://ns.adobe.com/rel/primary\"}", StandardCharsets.UTF_8.toString()))).withRequestKey(httpRequest.getRequestKey()).withHeaders(this.getDefaultHeaders());
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        return httpRequestCopy;
    }

    private Map<String, String> getDefaultHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", ACCEPT_HEADER_VALUE);
        headers.put("x-api-app-info", GlobalConfig.getAppInfo());
        headers.put("Prefer", "respond-async,wait=0");
        return headers;
    }
}

