/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.exception;

import java.util.Objects;

public class ServiceApiException
extends Exception {
    public final int DEFAULT_STATUS_CODE = 0;
    public final String DEFAULT_ERROR_CODE = "UNKNOWN";
    private String requestTrackingId;
    private int statusCode;
    private String errorCode;

    public ServiceApiException(String message) {
        super(message);
        this.statusCode = 0;
        this.errorCode = "UNKNOWN";
    }

    public ServiceApiException(String message, String requestTrackingId, int statusCode) {
        super(message);
        this.requestTrackingId = requestTrackingId;
        this.statusCode = statusCode;
        this.errorCode = "UNKNOWN";
    }

    public ServiceApiException(String message, String requestTrackingId, int statusCode, String errorCode) {
        this(message, requestTrackingId, statusCode);
        this.errorCode = Objects.nonNull(errorCode) ? errorCode : "UNKNOWN";
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        return String.format("description ='%s'; requestTrackingId='%s'; statusCode=%d; errorCode=%s", super.getMessage(), this.getRequestTrackingId(), this.getStatusCode(), this.getErrorCode());
    }

    public String getRequestTrackingId() {
        return this.requestTrackingId;
    }
}

