/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.pdfops.options.protectpdf;

import com.adobe.pdfservices.operation.pdfops.ProtectPDFOperation;

/**
 * Supported document permission types for {@link ProtectPDFOperation}
 */
public enum Permission {

    /**
     * Enables low quality printing of the PDF document
     */
    PRINT_LOW_QUALITY("PRINT_LOW_QUALITY"),

    /**
     * Enables high quality printing of the PDF document
     */
    PRINT_HIGH_QUALITY("PRINT_HIGH_QUALITY"),

    /**
     * Enables all the editing permissions in the PDF document except commenting and page extraction
     */
    EDIT_CONTENT("EDIT_CONTENT"),

    /**
     * Enables insertion, deletion and rotation of pages in a PDF document
     */
    EDIT_DOCUMENT_ASSEMBLY("EDIT_DOCUMENT_ASSEMBLY"),

    /**
     * Enables additions of comments, digital signatures and filling in of forms in a PDF document
     */
    EDIT_ANNOTATIONS("EDIT_ANNOTATIONS"),

    /**
     * Enables filling in of forms, digital signature and creation of template pages in a PDF document
     */
    EDIT_FILL_AND_SIGN_FORM_FIELDS("EDIT_FILL_AND_SIGN_FORM_FIELDS"),

    /**
     * Enables copying of content from the PDF document
     */
    COPY_CONTENT("COPY_CONTENT");

    private final String value;

    /**
     * Constructor.
     *
     * @param value permission value
     */
    Permission(String value) {
        this.value = value;
    }

    /**
     * Returns the value of this permission
     *
     * @return string value of this permission
     */
    public String getValue() {
        return value;
    }
}
