/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.pdfops.options.documentmerge;

import com.adobe.pdfservices.operation.pdfops.DocumentMergeOperation;

/**
 * Supported output formats for {@link DocumentMergeOperation}
 */
public enum OutputFormat {

    /**
     * Represents "application/vnd.openxmlformats-officedocument.wordprocessingml.document" media type
     */
    DOCX("docx"),
    /**
     * Represents "application/pdf" media type
     */
    PDF("pdf");

    private final String format;

    /**
     * Constructs output format with its string representation
     *
     * @param format String representation
     */
    OutputFormat(String format) {
        this.format = format;
    }

    /**
     * Returns the string representation of this outputformat
     *
     * @return String representation of this outputformat
     */
    public String getFormat() {
        return format;
    }
}
