/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.util;

import java.io.IOException;
import java.io.InputStream;

import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.http.InputStreamPart;

public class InputStreamUtil {

    private static final String FILE_FORM_FIELD_PREFIX = "file";

    public static String generateFileFormFieldName(int partNumber){
        return FILE_FORM_FIELD_PREFIX + partNumber;
    }
    public static InputStreamPart createInputStreamPart(FileRefImpl fileRefImpl, int partNumber) throws IOException {
      InputStream fileUploadBody = fileRefImpl.getAsStream();
      String fileName = fileRefImpl.getName();
      if (StringUtil.isBlank(fileName)) {
          fileName = FileUtil.getRandomFileName(fileRefImpl.getExtension());
      }
      return new InputStreamPart(generateFileFormFieldName(partNumber), fileUploadBody, fileName);
  }

}
