package com.adobe.pdfservices.operation.internal.service.ExtractPDFService;

import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.ExtractPDF.ExtractPDFOutput;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.ExtractPDF.ExtractRenditionOutput;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.ExtractPDF.StructuredData;
import com.adobe.pdfservices.operation.internal.util.FileUtil;
import com.adobe.pdfservices.operation.internal.util.JsonUtil;
import com.adobe.pdfservices.operation.internal.util.PathUtil;
import com.adobe.pdfservices.operation.internal.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipOutputStream;

public class ExtractDataZipper {
    private static void zipExtractedRenditions(ZipOutputStream zipOutputStream,
                                               List<ExtractRenditionOutput> extractRenditionOutputs) throws IOException {
        if(CollectionUtils.isNotEmpty(extractRenditionOutputs)) {
            for (ExtractRenditionOutput extractRenditionOutput : extractRenditionOutputs) {
                String fileName = PathUtil.getFileNameWithExtension(extractRenditionOutput.getFileName(),
                        extractRenditionOutput.getRenditionExtension());
                String folderName = "renditions";
                if (StringUtil.isBlank(fileName)) {
                    fileName = FileUtil.getRandomFileName(extractRenditionOutput.getRenditionExtension());
                }
                if (extractRenditionOutput.getRenditionsElementType() != null) {
                    folderName = extractRenditionOutput.getRenditionsElementType().name().toLowerCase();
                }
                fileName = PathUtil.getSubPath(folderName, fileName);
                FileUtil.addZipEntry(zipOutputStream, fileName, extractRenditionOutput.getInputStream());
            }
        }
    }

    private static void zipExtractedStructuredData(ZipOutputStream zipOutputStream, StructuredData structuredData)
            throws IOException {
        String fileName = structuredData.getFileName();
        FileUtil.addZipEntry(zipOutputStream, fileName, JsonUtil.convertMapToString(structuredData.getData().toMap()).getBytes("UTF-8"));
    }

    public static void zipExtractOutput(ExtractPDFOutput extractPDFOutput, String destinationPath) throws IOException {
        ZipOutputStream zipOutputStream = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(destinationPath);
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            zipExtractedStructuredData(zipOutputStream, extractPDFOutput.getStructuredElementData());
            zipExtractedRenditions(zipOutputStream, extractPDFOutput.getExtractedRenditions());
        } catch (IOException ex) {
            throw ex;
        } finally{
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
        }
    }
}
