/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.http;

import static com.adobe.pdfservices.operation.internal.http.DefaultRequestHeaders.DC_REQUEST_ID_HEADER_KEY;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class BaseHttpResponse<T> implements HttpResponse<T> {

    private int statusCode;
    private Map<String, String> headers;
    private T baseResponseDto;
    private List<InputStream> inputStreamList;

    public BaseHttpResponse(int statusCode, Map<String, String> headers, T baseResponseDto) {
        this.statusCode = statusCode;
        this.headers = headers;
        this.baseResponseDto = baseResponseDto;
    }

    public BaseHttpResponse(int statusCode, Map<String, String> headers) {
        this.statusCode = statusCode;
        this.headers = headers;
        this.inputStreamList = null;
        this.baseResponseDto = null;
    }

    @Override
    public Map<String, String> getHeaders() {
        return headers;
    }

    @Override
    public int getStatusCode() {
        return statusCode;
    }

    @Override
    public String getRequestId() {
        if (headers != null) {
            return headers.get(DC_REQUEST_ID_HEADER_KEY);
        }
        return null;
    }

    @Override
    public T getBody() {
        return baseResponseDto;
    }

    @Override
    public List<InputStream> getResponseAsStreamList() {
        return inputStreamList;
    }

    @Override
    public void consume() throws IOException {
        for(InputStream inputStream : inputStreamList) {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }


}
