/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.exception;

/**
 * Exception thrown when a failure HTTP response is thrown from the backend API
 */
public class OperationException extends RuntimeException {

    private String requestTrackingId;
    private int statusCode;
    private String completeResponseBody;
    private String errorCode;
    private String reportErrorCode;

    /**
     * A detailed error message received from the backend APIs for an error response. This property will always be populated
     * and suffices for any error debugging
     */
    private String errorMessage;

    public OperationException(String message) {
        super(message);

        this.requestTrackingId = null;
        this.statusCode = 0;
        this.completeResponseBody = null;

    }

    public OperationException(String errorMessage, String requestTrackingId, int statusCode) {
        super(errorMessage);
        this.errorMessage = errorMessage;
        this.requestTrackingId = requestTrackingId;
        this.statusCode = statusCode;
        this.completeResponseBody = null;
        this.errorCode = null;
        this.reportErrorCode = null;
    }

    public OperationException(String message, int httpStatusCode, String requestTrackingId,
                              String errorCode, String errorMessage, String completeResponseBody) {
        super(message);
        this.statusCode = httpStatusCode;
        this.requestTrackingId = requestTrackingId;
        this.completeResponseBody = completeResponseBody;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.reportErrorCode = null;

    }

    public OperationException(String message, int httpStatusCode, String requestTrackingId,
                              String errorCode, String errorMessage, String completeResponseBody, String reportErrorCode) {
        this(message, httpStatusCode, requestTrackingId, errorCode, errorMessage, completeResponseBody);
        this.reportErrorCode = reportErrorCode;

    }

    public int getStatusCode() {
        return statusCode;
    }

    public String getRequestTrackingId() {
        return requestTrackingId;
    }

    public String getCompleteResponseBody() {
        return completeResponseBody;
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    public String getErrorCode() {
        return errorCode;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public String getReportErrorCode() {
        return reportErrorCode;
    }

}
