/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.dto.response;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AuthenticationResponseDto {

    private String tokenType;
    private String accessToken;
    private long expiryInterval;


    @JsonCreator
    public AuthenticationResponseDto(@JsonProperty("token_type") String tokenType,
                                     @JsonProperty("access_token") String accessToken,
                                     @JsonProperty("expires_in") long expiryInterval) {
        this.tokenType = tokenType;
        this.accessToken = accessToken;
        this.expiryInterval = expiryInterval;
    }

    public String getAccessToken() {
        return accessToken;
    }

    public long getExpiryInterval() {
        return expiryInterval;
    }

}
