/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.cpf.dto.response.platform;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class CPFError {

    private String code;

    private String message;

    private CPFErrorDetails cpfErrorDetails;

    @JsonCreator
    public CPFError(@JsonProperty("code") String code,
                    @JsonProperty("message") String message,
                    @JsonProperty("details") CPFErrorDetails cpfErrorDetails) {
        this.code = code;
        this.message = message;
        this.cpfErrorDetails = cpfErrorDetails;
    }

    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    public CPFErrorDetails getCpfErrorDetails() {
        return cpfErrorDetails;
    }
}
