/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.cpf.dto.response.platform;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class CPFContentAnalyzerResponse {

    private CPFStatus CPFStatus;

    private CPFOutputs cpfOutputs;

    @JsonCreator
    public CPFContentAnalyzerResponse(@JsonProperty("cpf:status") CPFStatus CPFStatus,
                                      @JsonProperty("cpf:outputs") CPFOutputs cpfOutputs) {
        this.CPFStatus = CPFStatus;
        this.cpfOutputs = cpfOutputs;
    }

    public CPFContentAnalyzerResponse(@JsonProperty("cpf:status") CPFStatus cpfStatus) {
        this.CPFStatus = cpfStatus;
    }

    public CPFStatus getCPFStatus() {
        return CPFStatus;
    }

    public CPFOutputs getCpfOutputs() {
        return cpfOutputs;
    }
}
