/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.pagemanipulation;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class PageActionCommand {

    @JsonProperty("delete")
    private DeletePageAction delete;

    @JsonProperty("rotate")
    private RotatePageAction rotate;

    private PageActionCommand(DeletePageAction deletePageAction) {
        this.delete = deletePageAction;
    }

    private PageActionCommand(RotatePageAction rotatePageAction) {
        this.rotate = rotatePageAction;
    }

    public static PageActionCommand createFrom(PageAction pageAction) {
        PageActionCommand pageActionCommand = null;

        if(pageAction instanceof DeletePageAction) {
            pageActionCommand = new PageActionCommand((DeletePageAction) pageAction);
        } else if(pageAction instanceof RotatePageAction) {
            pageActionCommand = new PageActionCommand((RotatePageAction) pageAction);
        }

        return pageActionCommand;
    }
}
