/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.createpdf;

import com.adobe.pdfservices.operation.pdfops.options.createpdf.ppt.SupportedDocumentLanguage;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)

public class PPTFormatOptions {

  @JsonProperty("documentLanguage")
  private String documentLanguage;

  @JsonProperty("createTaggedPDF")
  private Boolean createTaggedPDF;

  @JsonCreator
  public PPTFormatOptions(SupportedDocumentLanguage documentLanguage, Boolean createTaggedPDF)
  {
    if(documentLanguage != null) {
      this.documentLanguage = documentLanguage.getDocumentLanguage();
    }
    this.createTaggedPDF = createTaggedPDF;
  }

}
