/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.createpdf;

import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.PlatformParams;
import com.adobe.pdfservices.operation.pdfops.options.createpdf.CreatePDFOptions;
import com.adobe.pdfservices.operation.pdfops.options.createpdf.excel.CreatePDFFromExcelOptions;
import com.adobe.pdfservices.operation.pdfops.options.createpdf.ppt.CreatePDFFromPPTOptions;
import com.adobe.pdfservices.operation.pdfops.options.createpdf.word.CreatePDFFromWordOptions;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class CreatePDFParams implements PlatformParams {

  @JsonProperty("excelFormatOptions")
  private ExcelFormatOptions excelFormatOptions;

  @JsonProperty("pptFormatOptions")
  private PPTFormatOptions pptFormatOptions;

  @JsonProperty("wordFormatOptions")
  private WordFormatOptions wordFormatOptions;

  private CreatePDFParams(CreatePDFOptions createPDFOptions) {
    if (createPDFOptions instanceof CreatePDFFromExcelOptions) {
      CreatePDFFromExcelOptions createPDFFromExcelOptions = (CreatePDFFromExcelOptions) createPDFOptions;
      excelFormatOptions = new ExcelFormatOptions(createPDFFromExcelOptions.getDocumentLanguage(), createPDFFromExcelOptions.getCreateTaggedPDF());
    } else if (createPDFOptions instanceof CreatePDFFromPPTOptions) {
      CreatePDFFromPPTOptions createPDFFromPPTOptions = (CreatePDFFromPPTOptions) createPDFOptions;
      pptFormatOptions = new PPTFormatOptions(createPDFFromPPTOptions.getDocumentLanguage(), createPDFFromPPTOptions.getCreateTaggedPDF());
    } else if (createPDFOptions instanceof CreatePDFFromWordOptions) {
      CreatePDFFromWordOptions createPDFFromWordOptions = (CreatePDFFromWordOptions) createPDFOptions;
      wordFormatOptions = new WordFormatOptions(createPDFFromWordOptions.getDocumentLanguage(), createPDFFromWordOptions.getCreateTaggedPDF());
    }
  }

  public static CreatePDFParams createFrom(CreatePDFOptions createPDFOptions) {
    CreatePDFParams createPDFParams = null;
    if(createPDFOptions != null) {
      createPDFParams = new CreatePDFParams(createPDFOptions);
    }
    return createPDFParams;
  }

}
