package com.adobe.pdfservices.operation.internal.cpf.dto.request.platform;

import com.adobe.pdfservices.operation.internal.cpf.constants.CPFConstants;
import com.fasterxml.jackson.annotation.JsonProperty;

public class ExtractPDFOutputFormat extends Outputs{

    @JsonProperty("elementsInfo")
    private MultiPartFormField elementsInfo;

    @JsonProperty("elementsRenditions")
    private MultiPartFormField elementsRenditions;

    public ExtractPDFOutputFormat(String elementsInfoFormat, String elementsRenditionsFormat) {
        this.elementsInfo = new MultiPartFormField(elementsInfoFormat,
                CPFConstants.ExtractPDF.PAPI_OUTPUT_EXTRACTED_JSON_KEY);
        this.elementsRenditions = new MultiPartFormField(elementsRenditionsFormat,
                CPFConstants.ExtractPDF.PAPI_OUTPUT_EXTRACTED_RENDITION_KEY);
    }
}
