/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.cpf.dto.request.platform;

import com.adobe.pdfservices.operation.pdfops.options.exportpdf.ExportPDFTargetFormat;
import com.adobe.pdfservices.operation.pdfops.options.exportpdftoimages.ExportPDFToImagesTargetFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class ExportPDFParams implements PlatformParams {

    private static final String LIST_OF_PAGE_IMAGES = "listOfPageImages";

    @JsonProperty("targetFormat")
    private String targetFormat;

    @JsonProperty("outputType")
    private String outputType;


    private ExportPDFParams(String targetFormat,String outputType) {
        this.targetFormat = targetFormat;
        this.outputType = outputType;
    }

    private ExportPDFParams(String targetFormat) {
        this.targetFormat = targetFormat;
        this.outputType = null;
    }

    public static ExportPDFParams createFrom(ExportPDFTargetFormat exportPDFTargetFormat) {
        return new ExportPDFParams(exportPDFTargetFormat.getFileExt());

    }

    public static ExportPDFParams createImagesFrom(ExportPDFToImagesTargetFormat exportPDFToImagesTargetFormat) {
            return new ExportPDFParams(exportPDFToImagesTargetFormat.getFileExt(), LIST_OF_PAGE_IMAGES);
    }
}
