/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.cpf.dto.request.platform;

import com.adobe.pdfservices.operation.pdfops.options.compresspdf.CompressPDFOptions;
import com.adobe.pdfservices.operation.pdfops.options.compresspdf.CompressionLevel;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class CompressPDFParams implements PlatformParams {

    @JsonProperty("compressionLevel")
    private String compressionLevel;

    private CompressPDFParams(CompressionLevel compressionLevel) {
        if(compressionLevel!=null) {
            this.compressionLevel = compressionLevel.getCompressionLevel();
        }
    }

    public static CompressPDFParams createFrom(CompressPDFOptions compressPDFOptions) {
        CompressPDFParams compressPDFParams = null;

        if(compressPDFOptions != null && compressPDFOptions.getCompressionLevel() != null) {
            compressPDFParams = new CompressPDFParams(compressPDFOptions.getCompressionLevel());
        }

        return compressPDFParams;
    }

}
